/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.channel;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.channel.MessageChannel;

public interface MessageReceiver {
    public void sendMessage(Text var1);

    default public void sendMessage(TextTemplate template) {
        this.sendMessage(Preconditions.checkNotNull(template, "template").apply().build());
    }

    default public void sendMessage(TextTemplate template, Map<String, TextElement> parameters) {
        this.sendMessage(Preconditions.checkNotNull(template, "template").apply(parameters).build());
    }

    default public void sendMessages(Text ... messages) {
        Preconditions.checkNotNull(messages, "messages");
        for (Text message : messages) {
            this.sendMessage(message);
        }
    }

    default public void sendMessages(Iterable<Text> messages) {
        for (Text message : Preconditions.checkNotNull(messages, "messages")) {
            this.sendMessage(message);
        }
    }

    public MessageChannel getMessageChannel();

    public void setMessageChannel(MessageChannel var1);
}

