/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.channel.type;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;

public class FixedMessageChannel
implements MessageChannel {
    protected final Set<MessageReceiver> recipients;

    public FixedMessageChannel(MessageReceiver ... recipients) {
        this(Arrays.asList((Object[])Preconditions.checkNotNull(recipients, "recipients")));
    }

    public FixedMessageChannel(Collection<? extends MessageReceiver> provided) {
        Set recipients = Collections.newSetFromMap(new WeakHashMap());
        recipients.addAll(provided);
        this.recipients = Collections.unmodifiableSet(recipients);
    }

    @Override
    public Collection<MessageReceiver> getMembers() {
        return this.recipients;
    }
}

