/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.format;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.serializer.TextFormatConfigSerializer;

public final class TextFormat
implements TextElement {
    public static final TextFormat NONE;
    private final TextColor color;
    private final TextStyle style;

    public static TextFormat of() {
        return NONE;
    }

    public static TextFormat of(TextStyle style) {
        return new TextFormat(TextColors.NONE, style);
    }

    public static TextFormat of(TextColor color) {
        return new TextFormat(color, TextStyles.NONE);
    }

    public static TextFormat of(TextColor color, TextStyle style) {
        return new TextFormat(color, style);
    }

    private TextFormat(TextColor color, TextStyle style) {
        this.color = Preconditions.checkNotNull(color, "color");
        this.style = Preconditions.checkNotNull(style, "style");
    }

    public TextColor getColor() {
        return this.color;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public TextFormat color(TextColor color) {
        return new TextFormat(color, this.style);
    }

    public TextFormat style(TextStyle style) {
        return new TextFormat(this.color, style);
    }

    public TextFormat merge(TextFormat format) {
        TextColor color = format.color;
        if (color == TextColors.NONE) {
            color = this.color;
        } else if (color == TextColors.RESET) {
            color = TextColors.NONE;
        }
        return new TextFormat(color, this.style.and(format.style));
    }

    public boolean isEmpty() {
        return this.color == TextColors.NONE && this.style.isEmpty();
    }

    @Override
    public void applyTo(Text.Builder builder) {
        builder.format(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextFormat)) {
            return false;
        }
        TextFormat that = (TextFormat)o;
        return this.color.equals(that.color) && this.style.equals(that.style);
    }

    public int hashCode() {
        return Objects.hashCode(this.color, this.style);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("color", this.color).add("style", this.style).toString();
    }

    static {
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(TextFormat.class), new TextFormatConfigSerializer());
        NONE = new TextFormat(TextColors.NONE, TextStyles.NONE);
    }
}

