/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.format;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextElement;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.OptBool;
import org.spongepowered.api.util.annotation.CatalogedBy;

@CatalogedBy(value={TextStyles.class})
public class TextStyle
implements TextElement {
    protected final Optional<Boolean> bold;
    protected final Optional<Boolean> italic;
    protected final Optional<Boolean> underline;
    protected final Optional<Boolean> strikethrough;
    protected final Optional<Boolean> obfuscated;

    public TextStyle(@Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underline, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated) {
        this(OptBool.of(bold), OptBool.of(italic), OptBool.of(underline), OptBool.of(strikethrough), OptBool.of(obfuscated));
    }

    private TextStyle(Optional<Boolean> bold, Optional<Boolean> italic, Optional<Boolean> underline, Optional<Boolean> strikethrough, Optional<Boolean> obfuscated) {
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.obfuscated = obfuscated;
        this.strikethrough = strikethrough;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean isEmpty() {
        return !this.bold.isPresent() && !this.italic.isPresent() && !this.underline.isPresent() && !this.strikethrough.isPresent() && !this.obfuscated.isPresent();
    }

    public TextStyle bold(@Nullable Boolean bold) {
        return new TextStyle(OptBool.of(bold), this.italic, this.underline, this.strikethrough, this.obfuscated);
    }

    public TextStyle italic(@Nullable Boolean italic) {
        return new TextStyle(this.bold, OptBool.of(italic), this.underline, this.strikethrough, this.obfuscated);
    }

    public TextStyle underline(@Nullable Boolean underline) {
        return new TextStyle(this.bold, this.italic, OptBool.of(underline), this.strikethrough, this.obfuscated);
    }

    public TextStyle strikethrough(@Nullable Boolean strikethrough) {
        return new TextStyle(this.bold, this.italic, this.underline, OptBool.of(strikethrough), this.obfuscated);
    }

    public TextStyle obfuscated(@Nullable Boolean obfuscated) {
        return new TextStyle(this.bold, this.italic, this.underline, this.strikethrough, OptBool.of(obfuscated));
    }

    public Optional<Boolean> isBold() {
        return this.bold;
    }

    public Optional<Boolean> isItalic() {
        return this.italic;
    }

    public Optional<Boolean> hasUnderline() {
        return this.underline;
    }

    public Optional<Boolean> hasStrikethrough() {
        return this.strikethrough;
    }

    public Optional<Boolean> isObfuscated() {
        return this.obfuscated;
    }

    public boolean contains(TextStyle ... styles) {
        for (TextStyle style : Preconditions.checkNotNull(styles, "styles")) {
            Preconditions.checkNotNull(style, "style");
            if (TextStyle.propContains(this.bold, style.bold) && TextStyle.propContains(this.italic, style.italic) && TextStyle.propContains(this.underline, style.underline) && TextStyle.propContains(this.strikethrough, style.strikethrough) && TextStyle.propContains(this.obfuscated, style.obfuscated)) continue;
            return false;
        }
        return true;
    }

    public TextStyle negate() {
        return new TextStyle(TextStyle.propNegate(this.bold), TextStyle.propNegate(this.italic), TextStyle.propNegate(this.underline), TextStyle.propNegate(this.strikethrough), TextStyle.propNegate(this.obfuscated));
    }

    public TextStyle and(TextStyle ... styles) {
        return this.compose(styles, false);
    }

    public TextStyle andNot(TextStyle ... styles) {
        return this.compose(styles, true);
    }

    private TextStyle compose(TextStyle[] styles, boolean negate) {
        Preconditions.checkNotNull(styles, "styles");
        if (styles.length == 0) {
            return this;
        }
        if (this.isEmpty() && styles.length == 1) {
            TextStyle style = Preconditions.checkNotNull(styles[0], "style");
            return negate ? style.negate() : style;
        }
        Optional<Boolean> boldAcc = this.bold;
        Optional<Boolean> italicAcc = this.italic;
        Optional<Boolean> underlineAcc = this.underline;
        Optional<Boolean> strikethroughAcc = this.strikethrough;
        Optional<Boolean> obfuscatedAcc = this.obfuscated;
        if (negate) {
            for (TextStyle style : styles) {
                Preconditions.checkNotNull(style, "style");
                boldAcc = TextStyle.propCompose(boldAcc, TextStyle.propNegate(style.bold));
                italicAcc = TextStyle.propCompose(italicAcc, TextStyle.propNegate(style.italic));
                underlineAcc = TextStyle.propCompose(underlineAcc, TextStyle.propNegate(style.underline));
                strikethroughAcc = TextStyle.propCompose(strikethroughAcc, TextStyle.propNegate(style.strikethrough));
                obfuscatedAcc = TextStyle.propCompose(obfuscatedAcc, TextStyle.propNegate(style.obfuscated));
            }
        } else {
            for (TextStyle style : styles) {
                Preconditions.checkNotNull(style, "style");
                boldAcc = TextStyle.propCompose(boldAcc, style.bold);
                italicAcc = TextStyle.propCompose(italicAcc, style.italic);
                underlineAcc = TextStyle.propCompose(underlineAcc, style.underline);
                strikethroughAcc = TextStyle.propCompose(strikethroughAcc, style.strikethrough);
                obfuscatedAcc = TextStyle.propCompose(obfuscatedAcc, style.obfuscated);
            }
        }
        return new TextStyle(boldAcc, italicAcc, underlineAcc, strikethroughAcc, obfuscatedAcc);
    }

    @Override
    public void applyTo(Text.Builder builder) {
        builder.style(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextStyle)) {
            return false;
        }
        TextStyle that = (TextStyle)o;
        return this.bold.equals(that.bold) && this.italic.equals(that.italic) && this.underline.equals(that.underline) && this.obfuscated.equals(that.obfuscated) && this.strikethrough.equals(that.strikethrough);
    }

    public int hashCode() {
        return Objects.hashCode(this.bold, this.italic, this.underline, this.obfuscated, this.strikethrough);
    }

    public String toString() {
        return MoreObjects.toStringHelper(TextStyle.class).omitNullValues().add("bold", this.bold.orElse(null)).add("italic", this.italic.orElse(null)).add("underline", this.underline.orElse(null)).add("strikethrough", this.strikethrough.orElse(null)).add("obfuscated", this.obfuscated.orElse(null)).toString();
    }

    private static boolean propContains(Optional<Boolean> superprop, Optional<Boolean> subprop) {
        return !subprop.isPresent() || superprop.equals(subprop);
    }

    private static Optional<Boolean> propNegate(Optional<Boolean> prop) {
        if (prop.isPresent()) {
            return OptBool.of(prop.get() == false);
        }
        return OptBool.ABSENT;
    }

    private static Optional<Boolean> propCompose(Optional<Boolean> prop1, Optional<Boolean> prop2) {
        if (!prop1.isPresent()) {
            return prop2;
        }
        if (!prop2.isPresent()) {
            return prop1;
        }
        if (!prop1.equals(prop2)) {
            return OptBool.ABSENT;
        }
        return prop1;
    }

    public static abstract class Base
    extends TextStyle
    implements CatalogType {
        protected Base(@Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underline, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated) {
            super(bold, italic, underline, strikethrough, obfuscated);
        }

        @Override
        public boolean isComposite() {
            return false;
        }
    }
}

