/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text.transform;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;

public interface TextFormatter<E extends TextRepresentable>
extends TextRepresentable,
Iterable<E> {
    public ImmutableList<E> getAll();

    public E get(int var1);

    default public <T extends TextRepresentable> Optional<T> firstAfter(int index, Class<T> clazz) {
        Preconditions.checkNotNull(clazz, "class");
        for (int i = index; i < this.size(); ++i) {
            E e = this.get(i);
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    default public <T extends TextRepresentable> Optional<T> first(Class<T> clazz) {
        return this.firstAfter(0, clazz);
    }

    default public <T extends TextRepresentable> void forEachAfter(int index, Class<T> clazz, Consumer<T> consumer) {
        Preconditions.checkNotNull(clazz, "class");
        for (int i = index; i < this.size(); ++i) {
            E e = this.get(i);
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            consumer.accept(e);
        }
    }

    default public <T extends TextRepresentable> void forEach(Class<T> clazz, Consumer<T> consumer) {
        this.forEachAfter(0, clazz, consumer);
    }

    public E set(int var1, E var2);

    public int size();

    public boolean isEmpty();

    public boolean contains(E var1);

    public void clear();

    public boolean add(E var1);

    public boolean add(Collection<E> var1);

    default public boolean add(Iterable<E> elements) {
        return this.add(Lists.newArrayList(elements));
    }

    default public boolean add(Iterator<E> elements) {
        return this.add(Lists.newArrayList(elements));
    }

    public void insert(int var1, E var2);

    public void insert(int var1, Collection<E> var2);

    default public void insert(int i, Iterable<E> elements) {
        this.insert(i, Lists.newArrayList(elements));
    }

    default public void insert(int i, Iterator<E> elements) {
        this.insert(i, Lists.newArrayList(elements));
    }

    public boolean remove(E var1);

    public boolean remove(Collection<E> var1);

    default public boolean remove(Iterable<E> elements) {
        return this.remove(Lists.newArrayList(elements));
    }

    default public boolean remove(Iterator<E> elements) {
        return this.remove(Lists.newArrayList(elements));
    }

    public boolean retain(Collection<E> var1);

    default public boolean retain(Iterable<E> elements) {
        return this.retain(Lists.newArrayList(elements));
    }

    default public boolean retain(Iterator<E> elements) {
        return this.retain(Lists.newArrayList(elements));
    }

    default public Text format() {
        Text text = Text.EMPTY;
        for (TextRepresentable e : this) {
            text = text.concat(e.toText());
        }
        return text.trim();
    }

    @Override
    default public Iterator<E> iterator() {
        return this.getAll().iterator();
    }

    @Override
    default public Text toText() {
        return this.format();
    }
}

