/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.generator;

import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class GeneratorUtils {
    public static String getClassName(String targetPackage, Class<?> clazz, String classifier) {
        String name = clazz.getName();
        return targetPackage + "." + name + "$" + classifier;
    }

    public static void visitBoxingMethod(MethodVisitor mv, Type type) {
        if (type.getSort() == 1) {
            mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else if (type.getSort() == 5) {
            mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (type.getSort() == 3) {
            mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (type.getSort() == 4) {
            mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (type.getSort() == 7) {
            mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
        } else if (type.getSort() == 6) {
            mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (type.getSort() == 8) {
            mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
        } else if (type.getSort() == 2) {
            mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
        }
    }

    public static void visitUnboxingMethod(MethodVisitor mv, Type type) {
        if (type.getSort() == 1) {
            mv.visitTypeInsn(192, "java/lang/Boolean");
            mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (type.getSort() == 5) {
            mv.visitTypeInsn(192, "java/lang/Integer");
            mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
        } else if (type.getSort() == 3) {
            mv.visitTypeInsn(192, "java/lang/Byte");
            mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
        } else if (type.getSort() == 4) {
            mv.visitTypeInsn(192, "java/lang/Short");
            mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
        } else if (type.getSort() == 7) {
            mv.visitTypeInsn(192, "java/lang/Long");
            mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
        } else if (type.getSort() == 6) {
            mv.visitTypeInsn(192, "java/lang/Float");
            mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
        } else if (type.getSort() == 8) {
            mv.visitTypeInsn(192, "java/lang/Double");
            mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
        } else if (type.getSort() == 2) {
            mv.visitTypeInsn(192, "java/lang/Character");
            mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
        } else {
            mv.visitTypeInsn(192, type.getInternalName());
        }
    }

    private GeneratorUtils() {
    }

    public static class LocalClassLoader
    extends ClassLoader {
        public LocalClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> defineClass(String name, byte[] b2) {
            return this.defineClass(name, b2, 0, b2.length);
        }
    }
}

