/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.generator.dummy;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class DummyClassGenerator {
    private static final String FIELD_NAME = "fieldName";

    public byte[] createClass(Class<?> type, String name, Class<?> exceptionType) {
        Preconditions.checkNotNull(type, "type");
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(exceptionType, "exception");
        Preconditions.checkState(type.isInterface(), String.format("Class %s is not an interface!", type));
        Preconditions.checkState(Throwable.class.isAssignableFrom(exceptionType), String.format("Class %s does not extend Throwable!", exceptionType));
        String internalName = name.replace('.', '/');
        List<Method> methods = this.getInterfaceMethods(type);
        ClassWriter cw = new ClassWriter(3);
        cw.visit(52, 33, internalName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(type)});
        this.generateConstructor(cw, internalName);
        this.generateMethods(cw, internalName, methods, exceptionType);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void generateConstructor(ClassWriter cw, String internalName) {
        cw.visitField(2, FIELD_NAME, Type.getDescriptor(String.class), null, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/lang/String;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, internalName, FIELD_NAME, Type.getDescriptor(String.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void generateMethods(ClassWriter cw, String internalName, List<Method> methods, Class<?> exceptionType) {
        for (Method method : methods) {
            MethodVisitor mv = cw.visitMethod(1, method.getName(), Type.getMethodDescriptor(method), null, null);
            mv.visitCode();
            String internalException = Type.getInternalName(exceptionType);
            mv.visitTypeInsn(187, internalException);
            mv.visitInsn(89);
            mv.visitLdcInsn("A method was invoked on a dummy class, due to the static field %s not being initialized (most likely in a CatalogType-related class).\nMethod: " + method);
            mv.visitLdcInsn(1);
            mv.visitTypeInsn(189, "java/lang/String");
            mv.visitVarInsn(58, 2);
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn(0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, internalName, FIELD_NAME, Type.getDescriptor(String.class));
            mv.visitInsn(83);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(184, Type.getInternalName(String.class), "format", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
            mv.visitMethodInsn(183, internalException, "<init>", "(Ljava/lang/String;)V", false);
            mv.visitInsn(191);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private List<Method> getInterfaceMethods(Class<?> clazz) {
        Method[] allMethods;
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : allMethods = clazz.getMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            methods.add(method);
        }
        return methods;
    }
}

