/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import com.flowpowered.math.GenericMath;
import com.google.common.base.MoreObjects;
import java.util.Random;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.Queries;

@FunctionalInterface
public interface VariableAmount
extends DataSerializable {
    public static VariableAmount fixed(double value) {
        return new Fixed(value);
    }

    public static VariableAmount range(double min, double max) {
        return new BaseAndAddition(min, VariableAmount.fixed(max - min));
    }

    public static VariableAmount baseWithVariance(double base, double variance) {
        return new BaseAndVariance(base, VariableAmount.fixed(variance));
    }

    public static VariableAmount baseWithVariance(double base, VariableAmount variance) {
        return new BaseAndVariance(base, variance);
    }

    public static VariableAmount baseWithRandomAddition(double base, double addition) {
        return new BaseAndAddition(base, VariableAmount.fixed(addition));
    }

    public static VariableAmount baseWithRandomAddition(double base, VariableAmount addition) {
        return new BaseAndAddition(base, addition);
    }

    public static VariableAmount baseWithOptionalVariance(double base, double variance, double chance) {
        return new OptionalAmount(base, chance, VariableAmount.baseWithVariance(base, variance));
    }

    public static VariableAmount baseWithOptionalVariance(double base, VariableAmount variance, double chance) {
        return new OptionalAmount(base, chance, VariableAmount.baseWithVariance(base, variance));
    }

    public static VariableAmount baseWithOptionalAddition(double base, double addition, double chance) {
        return new OptionalAmount(base, chance, VariableAmount.baseWithRandomAddition(base, addition));
    }

    public static VariableAmount baseWithOptionalAddition(double base, VariableAmount addition, double chance) {
        return new OptionalAmount(base, chance, VariableAmount.baseWithRandomAddition(base, addition));
    }

    public double getAmount(Random var1);

    default public int getFlooredAmount(Random rand) {
        return GenericMath.floor(this.getAmount(rand));
    }

    @Override
    default public DataContainer toContainer() {
        throw new UnsupportedOperationException();
    }

    @Override
    default public int getContentVersion() {
        return 0;
    }

    public static class OptionalAmount
    implements VariableAmount {
        private double chance;
        private double base;
        private VariableAmount inner;

        OptionalAmount(double base, double chance, VariableAmount inner) {
            this.base = base;
            this.inner = inner;
            this.chance = chance;
        }

        @Override
        public double getAmount(Random rand) {
            if (rand.nextDouble() < this.chance) {
                return this.inner.getAmount(rand);
            }
            return this.base;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("base", this.base).add("chance", this.chance).add("inner", this.inner).toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OptionalAmount)) {
                return false;
            }
            OptionalAmount amount = (OptionalAmount)obj;
            return this.inner.equals(amount.inner) && amount.base == this.base && this.chance == amount.chance;
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + (int)(Double.doubleToLongBits(this.base) ^ Double.doubleToLongBits(this.base) >> 32);
            result = 37 * result + (int)(Double.doubleToLongBits(this.chance) ^ Double.doubleToLongBits(this.chance) >> 32);
            result = 37 * result + this.inner.hashCode();
            return result;
        }

        @Override
        public DataContainer toContainer() {
            return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.VARIABLE_CHANCE, (Object)this.chance).set(Queries.VARIABLE_BASE, (Object)this.base).set(Queries.VARIABLE_VARIANCE, (Object)this.inner);
        }

        @Override
        public int getContentVersion() {
            return 1;
        }
    }

    public static class BaseAndAddition
    implements VariableAmount {
        private double base;
        private VariableAmount addition;

        BaseAndAddition(double base, VariableAmount addition) {
            this.base = base;
            this.addition = addition;
        }

        @Override
        public double getAmount(Random rand) {
            return this.base + rand.nextDouble() * this.addition.getAmount(rand);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("base", this.base).add("addition", this.addition).toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BaseAndAddition)) {
                return false;
            }
            BaseAndAddition amount = (BaseAndAddition)obj;
            return amount.base == this.base && amount.addition == this.addition;
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + (int)(Double.doubleToLongBits(this.base) ^ Double.doubleToLongBits(this.base) >> 32);
            result = 37 * result + this.addition.hashCode();
            return result;
        }

        @Override
        public DataContainer toContainer() {
            return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.VARIABLE_BASE, (Object)this.base).set(Queries.VARIABLE_VARIANCE, (Object)this.addition);
        }

        @Override
        public int getContentVersion() {
            return 1;
        }
    }

    public static class BaseAndVariance
    implements VariableAmount {
        private double base;
        private VariableAmount variance;

        BaseAndVariance(double base, VariableAmount variance) {
            this.base = base;
            this.variance = variance;
        }

        @Override
        public double getAmount(Random rand) {
            double var = this.variance.getAmount(rand);
            return this.base + rand.nextDouble() * var * 2.0 - var;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("base", this.base).add("variance", this.variance).toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BaseAndVariance)) {
                return false;
            }
            BaseAndVariance amount = (BaseAndVariance)obj;
            return amount.base == this.base && amount.variance == this.variance;
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + (int)(Double.doubleToLongBits(this.base) ^ Double.doubleToLongBits(this.base) >> 32);
            result = 37 * result + this.variance.hashCode();
            return result;
        }

        @Override
        public DataContainer toContainer() {
            return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.VARIABLE_BASE, (Object)this.base).set(Queries.VARIABLE_VARIANCE, (Object)this.variance);
        }

        @Override
        public int getContentVersion() {
            return 1;
        }
    }

    public static class Fixed
    implements VariableAmount {
        private double amount;

        Fixed(double amount) {
            this.amount = amount;
        }

        @Override
        public double getAmount(Random rand) {
            return this.amount;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("amount", this.amount).toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Fixed)) {
                return false;
            }
            Fixed amount = (Fixed)obj;
            return amount.amount == this.amount;
        }

        public int hashCode() {
            int result = 1;
            result = 37 * result + (int)(Double.doubleToLongBits(this.amount) ^ Double.doubleToLongBits(this.amount) >> 32);
            return result;
        }

        @Override
        public DataContainer toContainer() {
            return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.VARIABLE_AMOUNT, (Object)this.amount);
        }

        @Override
        public int getContentVersion() {
            return 1;
        }
    }
}

