/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util.weighted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.util.weighted.TableEntry;

public class WeightedObject<T>
extends TableEntry<T> {
    private final T object;

    public WeightedObject(T obj, double weight) {
        super(weight);
        this.object = Preconditions.checkNotNull(obj);
    }

    public T get() {
        return this.object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WeightedObject)) {
            return false;
        }
        WeightedObject c2 = (WeightedObject)o;
        return this.object.equals(c2.object) && this.getWeight() == c2.getWeight();
    }

    public int hashCode() {
        int r = 1;
        long w = Double.doubleToLongBits(this.getWeight());
        r = r * 37 + (int)(w ^ w >>> 32);
        r = r * 37 + this.object.hashCode();
        return r;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("object", this.object).toString();
    }
}

