/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.block.ScheduledBlockUpdate;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.Extent;

public final class Location<E extends Extent>
implements DataHolder {
    private final WeakReference<E> extent;
    @Nullable
    private Vector3d position = null;
    @Nullable
    private Vector3i blockPosition = null;
    @Nullable
    private Vector3i chunkPosition = null;
    @Nullable
    private Vector3i biomePosition = null;

    public Location(E extent, Vector3d position) {
        this.extent = new WeakReference<E>(Preconditions.checkNotNull(extent, "extent"));
        this.position = Preconditions.checkNotNull(position, "position");
    }

    public Location(E extent, double x, double y, double z) {
        this(extent, new Vector3d(x, y, z));
    }

    public Location(E extent, Vector3i blockPosition) {
        this.extent = new WeakReference<E>(Preconditions.checkNotNull(extent, "extent"));
        this.blockPosition = Preconditions.checkNotNull(blockPosition, "blockPosition");
    }

    public Location(E extent, int x, int y, int z) {
        this(extent, new Vector3i(x, y, z));
    }

    public boolean isAvailable() {
        return this.extent.get() != null;
    }

    public E getExtent() {
        Extent currentExtent = (Extent)this.extent.get();
        if (currentExtent == null) {
            throw new IllegalStateException();
        }
        return (E)currentExtent;
    }

    public Vector3d getPosition() {
        if (this.position == null) {
            Preconditions.checkState(this.blockPosition != null);
            this.position = this.getBlockPosition().toDouble();
        }
        return this.position;
    }

    public Vector3i getBlockPosition() {
        if (this.blockPosition == null) {
            Preconditions.checkState(this.position != null);
            this.blockPosition = this.getPosition().toInt();
        }
        return this.blockPosition;
    }

    public Vector3i getChunkPosition() {
        if (this.chunkPosition == null) {
            this.chunkPosition = Sponge.getServer().getChunkLayout().forceToChunk(this.getBlockPosition());
        }
        return this.chunkPosition;
    }

    public Vector3i getBiomePosition() {
        if (this.biomePosition == null) {
            Vector3i blockPosition = this.getBlockPosition();
            this.biomePosition = new Vector3i(blockPosition.getX(), 0, blockPosition.getZ());
        }
        return this.biomePosition;
    }

    public double getX() {
        return this.getPosition().getX();
    }

    public double getY() {
        return this.getPosition().getY();
    }

    public double getZ() {
        return this.getPosition().getZ();
    }

    public int getBlockX() {
        return this.getBlockPosition().getX();
    }

    public int getBlockY() {
        return this.getBlockPosition().getY();
    }

    public int getBlockZ() {
        return this.getBlockPosition().getZ();
    }

    public boolean inExtent(Extent extent) {
        return this.getExtent().equals(extent);
    }

    public boolean hasBiome() {
        return this.getExtent().containsBiome(this.getBiomePosition());
    }

    public boolean hasBlock() {
        return this.getExtent().containsBlock(this.getBlockPosition());
    }

    public Optional<LocatableBlock> getLocatableBlock() {
        return this.getExtent() instanceof World ? Optional.of(LocatableBlock.builder().world((World)this.getExtent()).position(this.getBlockPosition()).build()) : Optional.empty();
    }

    public Location<E> setExtent(E extent) {
        Preconditions.checkNotNull(extent, "extent");
        if (extent == this.getExtent()) {
            return this;
        }
        return new Location<E>(extent, this.getPosition());
    }

    public Location<E> setPosition(Vector3d position) {
        Preconditions.checkNotNull(position, "position");
        if (position == this.getPosition()) {
            return this;
        }
        return new Location<E>(this.getExtent(), position);
    }

    public Location<E> setBlockPosition(Vector3i position) {
        Preconditions.checkNotNull(position, "position");
        if (position == this.getBlockPosition()) {
            return this;
        }
        return new Location<E>(this.getExtent(), position);
    }

    public Location<E> sub(Vector3d v) {
        return this.sub(v.getX(), v.getY(), v.getZ());
    }

    public Location<E> sub(Vector3i v) {
        return this.sub(v.getX(), v.getY(), v.getZ());
    }

    public Location<E> sub(double x, double y, double z) {
        return this.setPosition(this.getPosition().sub(x, y, z));
    }

    public Location<E> add(Vector3d v) {
        return this.add(v.getX(), v.getY(), v.getZ());
    }

    public Location<E> add(Vector3i v) {
        return this.add(v.getX(), v.getY(), v.getZ());
    }

    public Location<E> add(double x, double y, double z) {
        return this.setPosition(this.getPosition().add(x, y, z));
    }

    public <T> T map(BiFunction<E, Vector3d, T> mapper) {
        return mapper.apply(this.getExtent(), this.getPosition());
    }

    public <T> T mapBlock(BiFunction<E, Vector3i, T> mapper) {
        return mapper.apply(this.getExtent(), this.getBlockPosition());
    }

    public <T> T mapChunk(BiFunction<E, Vector3i, T> mapper) {
        return mapper.apply(this.getExtent(), this.getChunkPosition());
    }

    public <T> T mapBiome(BiFunction<E, Vector3i, T> mapper) {
        return mapper.apply(this.getExtent(), this.getBiomePosition());
    }

    public Location<E> getRelative(Direction direction) {
        return this.add(direction.asOffset());
    }

    public Location<E> getBlockRelative(Direction direction) {
        Preconditions.checkArgument(!direction.isSecondaryOrdinal(), "Secondary cardinal directions can't be used here");
        return this.add(direction.asBlockOffset());
    }

    public BiomeType getBiome() {
        return this.getExtent().getBiome(this.getBiomePosition());
    }

    public BlockType getBlockType() {
        return this.getExtent().getBlockType(this.getBlockPosition());
    }

    public BlockState getBlock() {
        return this.getExtent().getBlock(this.getBlockPosition());
    }

    public boolean hasTileEntity() {
        return this.getExtent().getTileEntity(this.getBlockPosition()).isPresent();
    }

    public Optional<TileEntity> getTileEntity() {
        return this.getExtent().getTileEntity(this.getBlockPosition());
    }

    public boolean setBlock(BlockState state) {
        return this.getExtent().setBlock(this.getBlockPosition(), state);
    }

    public boolean setBlock(BlockState state, BlockChangeFlag flag) {
        return this.getExtent().setBlock(this.getBlockPosition(), state, flag);
    }

    public boolean setBlockType(BlockType type) {
        return this.getExtent().setBlockType(this.getBlockPosition(), type);
    }

    public boolean setBlockType(BlockType type, BlockChangeFlag flag) {
        return this.getExtent().setBlockType(this.getBlockPosition(), type, flag);
    }

    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return this.getExtent().restoreSnapshot(this.getBlockPosition(), snapshot, force, flag);
    }

    public boolean removeBlock() {
        return this.getExtent().setBlockType(this.getBlockPosition(), BlockTypes.AIR, BlockChangeFlags.ALL);
    }

    public Entity createEntity(EntityType type) {
        return this.getExtent().createEntity(type, this.getPosition());
    }

    public boolean spawnEntity(Entity entity) {
        return this.getExtent().spawnEntity(entity);
    }

    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        return this.getExtent().spawnEntities(entities);
    }

    public Location<E> asHighestLocation() {
        return this.setBlockPosition(this.getExtent().getHighestPositionAt(this.getBlockPosition()));
    }

    @Override
    public DataTransactionResult remove(Class<? extends DataManipulator<?, ?>> containerClass) {
        return this.getExtent().remove(this.getBlockPosition(), containerClass);
    }

    @Override
    public DataTransactionResult remove(BaseValue<?> value) {
        return this.getExtent().remove(this.getBlockPosition(), value.getKey());
    }

    @Override
    public DataTransactionResult remove(Key<?> key) {
        return this.getExtent().remove(this.getBlockPosition(), key);
    }

    public BlockSnapshot createSnapshot() {
        return this.getExtent().createSnapshot(this.getBlockPosition());
    }

    public Collection<ScheduledBlockUpdate> getScheduledUpdates() {
        return this.getExtent().getScheduledUpdates(this.getBlockPosition());
    }

    public ScheduledBlockUpdate addScheduledUpdate(int priority, int ticks) {
        return this.getExtent().addScheduledUpdate(this.getBlockPosition(), priority, ticks);
    }

    public void removeScheduledUpdate(ScheduledBlockUpdate update) {
        this.getExtent().removeScheduledUpdate(this.getBlockPosition(), update);
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return this.getExtent().getProperty(this.getBlockPosition(), propertyClass);
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return this.getExtent().getProperties(this.getBlockPosition());
    }

    @Override
    public boolean validateRawData(DataView container) {
        return this.getExtent().validateRawData(this.getBlockPosition(), container);
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        this.getExtent().setRawData(this.getBlockPosition(), container);
    }

    @Override
    public int getContentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        DataContainer container = DataContainer.createNew();
        container.set(Queries.CONTENT_VERSION, (Object)this.getContentVersion());
        if (this.getExtent() instanceof World) {
            container.set(Queries.WORLD_ID, (Object)this.getExtent().getUniqueId().toString());
        } else if (this.getExtent() instanceof Chunk) {
            container.set(Queries.CHUNK_X, (Object)((Chunk)this.getExtent()).getPosition().getX()).set(Queries.CHUNK_Y, (Object)((Chunk)this.getExtent()).getPosition().getY()).set(Queries.CHUNK_Z, (Object)((Chunk)this.getExtent()).getPosition().getZ()).set(Queries.WORLD_ID, (Object)((Chunk)this.getExtent()).getWorld().getUniqueId().toString());
        }
        container.set(Queries.POSITION_X, (Object)this.getX()).set(Queries.POSITION_Y, (Object)this.getY()).set(Queries.POSITION_Z, (Object)this.getZ());
        return container;
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        return this.getExtent().get(this.getBlockPosition(), containerClass);
    }

    @Override
    public <T> Optional<T> get(Key<? extends BaseValue<T>> key) {
        return this.getExtent().get(this.getBlockPosition(), key);
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        return this.getExtent().getOrCreate(this.getBlockPosition(), containerClass);
    }

    @Override
    public <T> DataTransactionResult offer(Key<? extends BaseValue<T>> key, T value) {
        return this.getExtent().offer(this.getBlockPosition(), key, value);
    }

    @Override
    public DataTransactionResult offer(Iterable<DataManipulator<?, ?>> valueHolders) {
        return this.getExtent().offer(this.getBlockPosition(), valueHolders);
    }

    @Override
    public DataTransactionResult offer(Iterable<DataManipulator<?, ?>> values, MergeFunction function) {
        return this.getExtent().offer(this.getBlockPosition(), values, function);
    }

    @Override
    public <T> DataTransactionResult offer(BaseValue<T> value) {
        return this.getExtent().offer(this.getBlockPosition(), value);
    }

    @Override
    public DataTransactionResult offer(DataManipulator<?, ?> valueContainer) {
        return this.getExtent().offer(this.getBlockPosition(), valueContainer);
    }

    @Override
    public DataTransactionResult offer(DataManipulator<?, ?> valueContainer, MergeFunction function) {
        return this.getExtent().offer(this.getBlockPosition(), valueContainer, function);
    }

    @Override
    public DataTransactionResult undo(DataTransactionResult result) {
        return this.getExtent().undo(this.getBlockPosition(), result);
    }

    @Override
    public boolean supports(Class<? extends DataManipulator<?, ?>> holderClass) {
        return this.getExtent().supports(this.getBlockPosition(), holderClass);
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.getExtent().supports(this.getBlockPosition(), key);
    }

    @Override
    public <T> DataTransactionResult transform(Key<? extends BaseValue<T>> key, Function<T, T> function) {
        return this.getExtent().transform(this.getBlockPosition(), key, function);
    }

    @Override
    public DataTransactionResult copyFrom(DataHolder that) {
        return this.getExtent().copyFrom(this.getBlockPosition(), that);
    }

    @Override
    public DataTransactionResult copyFrom(DataHolder that, MergeFunction strategy) {
        return this.getExtent().copyFrom(this.getBlockPosition(), that, strategy);
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        return this.getExtent().getManipulators(this.getBlockPosition());
    }

    @Override
    public <T, V extends BaseValue<T>> Optional<V> getValue(Key<V> key) {
        return this.getExtent().getValue(this.getBlockPosition(), key);
    }

    @Override
    public Location<E> copy() {
        return new Location<E>(this.getExtent(), this.getPosition());
    }

    @Override
    public Set<Key<?>> getKeys() {
        return this.getExtent().getKeys(this.getBlockPosition());
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        return this.getExtent().getValues(this.getBlockPosition());
    }

    public String toString() {
        return "Location{" + this.getPosition() + " in " + this.getExtent() + "}";
    }

    public int hashCode() {
        return Objects.hashCode(this.getExtent(), this.getPosition());
    }

    public boolean equals(Object other) {
        if (!(other instanceof Location)) {
            return false;
        }
        Location otherLoc = (Location)other;
        return otherLoc.getExtent().equals(this.getExtent()) && otherLoc.getPosition().equals(this.getPosition());
    }
}

