/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.world.extent;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;

public interface InteractableVolume
extends MutableBlockVolume {
    default public boolean hitBlock(Vector3i position, Direction side, GameProfile profile) {
        return this.hitBlock(Preconditions.checkNotNull(position, "position").getX(), position.getY(), position.getZ(), side, profile);
    }

    public boolean hitBlock(int var1, int var2, int var3, Direction var4, GameProfile var5);

    default public boolean interactBlock(Vector3i position, Direction side, GameProfile profile) {
        return this.interactBlock(Preconditions.checkNotNull(position, "position").getX(), position.getY(), position.getZ(), side, profile);
    }

    public boolean interactBlock(int var1, int var2, int var3, Direction var4, GameProfile var5);

    default public boolean interactBlockWith(Vector3i position, ItemStack itemStack, Direction side, GameProfile profile) {
        return this.interactBlockWith(Preconditions.checkNotNull(position, "position").getX(), position.getY(), position.getZ(), itemStack, side, profile);
    }

    public boolean interactBlockWith(int var1, int var2, int var3, ItemStack var4, Direction var5, GameProfile var6);

    default public boolean placeBlock(Vector3i position, BlockState block, Direction side, GameProfile profile) {
        return this.placeBlock(Preconditions.checkNotNull(position, "position").getX(), position.getY(), position.getZ(), block, side, profile);
    }

    public boolean placeBlock(int var1, int var2, int var3, BlockState var4, Direction var5, GameProfile var6);

    default public boolean digBlock(Vector3i position, GameProfile profile) {
        return this.digBlock(Preconditions.checkNotNull(position, "position").getX(), position.getY(), position.getZ(), profile);
    }

    public boolean digBlock(int var1, int var2, int var3, GameProfile var4);

    default public boolean digBlockWith(Vector3i position, ItemStack itemStack, GameProfile profile) {
        return this.digBlockWith(Preconditions.checkNotNull(position, "position").getX(), position.getY(), position.getZ(), itemStack, profile);
    }

    public boolean digBlockWith(int var1, int var2, int var3, ItemStack var4, GameProfile var5);

    default public int getBlockDigTimeWith(Vector3i position, ItemStack itemStack, GameProfile profile) {
        return this.getBlockDigTimeWith(Preconditions.checkNotNull(position, "position").getX(), position.getY(), position.getZ(), itemStack, profile);
    }

    public int getBlockDigTimeWith(int var1, int var2, int var3, ItemStack var4, GameProfile var5);

    @Override
    public MutableBlockVolumeWorker<? extends InteractableVolume> getBlockWorker();
}

