/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.service.ChangeServiceProviderEvent;
import org.spongepowered.api.event.world.SaveWorldEvent;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.server.management.PlayerProfileCacheBridge;
import org.spongepowered.common.service.user.SpongeUserStorageService;
import org.spongepowered.common.util.SpongeUsernameCache;

public class SpongeInternalListeners {
    private Multimap<Class<?>, Predicate<Object>> serviceCallbacks = HashMultimap.create();

    public static SpongeInternalListeners getInstance() {
        return Holder.INSTANCE;
    }

    public <T> void registerExpirableServiceCallback(Class<T> service, Predicate<T> callback) {
        this.serviceCallbacks.put(service, callback);
    }

    public <T> void registerServiceCallback(Class<T> service, Consumer<T> callback) {
        this.registerExpirableServiceCallback(service, o -> {
            callback.accept(o);
            return true;
        });
    }

    @Listener
    public void onServerStarting(GameStartingServerEvent event) {
        Sponge.getServiceManager().provide(UserStorageService.class).filter(x -> x instanceof SpongeUserStorageService).ifPresent(x -> ((SpongeUserStorageService)x).init());
    }

    @Listener
    public void onServiceChange(ChangeServiceProviderEvent event) {
        Iterator<Predicate<Object>> it = this.serviceCallbacks.get(event.getService()).iterator();
        while (it.hasNext()) {
            if (it.next().test(event.getNewProvider())) continue;
            it.remove();
        }
    }

    @Listener
    public void onWorldSave(SaveWorldEvent event) {
        if (Sponge.getServer().getDefaultWorld().isPresent() && event.getTargetWorld().getUniqueId().equals(Sponge.getServer().getDefaultWorld().get().getUniqueId())) {
            SpongeUsernameCache.save();
            MinecraftServer server = SpongeImpl.getServer();
            ((PlayerProfileCacheBridge)server.func_152358_ax()).bridge$setCanSave(true);
            server.func_152358_ax().func_152658_c();
            ((PlayerProfileCacheBridge)server.func_152358_ax()).bridge$setCanSave(false);
        }
    }

    SpongeInternalListeners() {
    }

    private static final class Holder {
        static final SpongeInternalListeners INSTANCE = new SpongeInternalListeners();

        private Holder() {
        }
    }
}

