/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;

public abstract class AbstractCriterionBuilder<T extends AdvancementCriterion, B extends AdvancementCriterion.BaseBuilder<T, B>>
implements AdvancementCriterion.BaseBuilder<T, B> {
    @Nullable
    protected FilteredTrigger<?> trigger;
    @Nullable
    protected String name;

    @Override
    public B trigger(FilteredTrigger<?> trigger) {
        Preconditions.checkNotNull(trigger, "trigger");
        this.trigger = trigger;
        return (B)this;
    }

    @Override
    public B name(String name) {
        Preconditions.checkNotNull(name, "name");
        this.name = name;
        return (B)this;
    }

    @Override
    public T build() {
        Preconditions.checkState(this.name != null, "The name must be set");
        return this.build0();
    }

    abstract T build0();

    @Override
    public B from(T value) {
        this.trigger = value.getTrigger().orElse(null);
        this.name = value.getName();
        return (B)this;
    }

    @Override
    public B reset() {
        this.trigger = null;
        this.name = null;
        return (B)this;
    }
}

