/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.FixedTranslation;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.advancement.SpongeAdvancementTree;
import org.spongepowered.common.bridge.advancements.AdvancementBridge;
import org.spongepowered.common.bridge.advancements.DisplayInfoBridge;
import org.spongepowered.common.util.SpongeCatalogBuilder;

public class SpongeAdvancementTreeBuilder
extends SpongeCatalogBuilder<AdvancementTree, AdvancementTree.Builder>
implements AdvancementTree.Builder {
    private Advancement rootAdvancement;
    private String background;

    public SpongeAdvancementTreeBuilder() {
        this.reset();
    }

    @Override
    public AdvancementTree.Builder rootAdvancement(Advancement rootAdvancement) {
        Preconditions.checkNotNull(rootAdvancement, "rootAdvancement");
        Preconditions.checkState(((AdvancementBridge)((Object)rootAdvancement)).bridge$isRegistered(), "The root advancement must be registered.");
        Preconditions.checkState(!rootAdvancement.getParent().isPresent(), "The root advancement cannot have a parent.");
        Preconditions.checkState(rootAdvancement.getDisplayInfo().isPresent(), "The root advancement must have display info.");
        Preconditions.checkState(((DisplayInfoBridge)((Object)rootAdvancement.getDisplayInfo().get())).bridge$getBackground() == null, "The root advancement is already used by a different Advancement Tree.");
        this.rootAdvancement = rootAdvancement;
        return this;
    }

    @Override
    public AdvancementTree.Builder background(String background) {
        Preconditions.checkNotNull(background, "background");
        this.background = background;
        return this;
    }

    @Override
    public Translation getName() {
        if (this.name != null) {
            return this.name;
        }
        return new FixedTranslation(this.rootAdvancement.getDisplayInfo().map(info -> info.getTitle().toPlain()).orElse(this.id));
    }

    @Override
    protected AdvancementTree build(PluginContainer plugin, String id, Translation name) {
        Preconditions.checkState(this.rootAdvancement != null, "The root advancement must be set");
        SpongeAdvancementTree advancementTree = new SpongeAdvancementTree(this.rootAdvancement, plugin.getId() + ':' + this.id, name);
        ((DisplayInfoBridge)((Object)this.rootAdvancement.getDisplayInfo().get())).bridge$setBackground(this.background);
        ((AdvancementBridge)((Object)this.rootAdvancement)).bridge$setParent(null);
        SpongeAdvancementTreeBuilder.applyTree(this.rootAdvancement, advancementTree);
        return advancementTree;
    }

    private static void applyTree(Advancement advancement, AdvancementTree tree) {
        ((AdvancementBridge)((Object)advancement)).bridge$setTree(tree);
        for (Advancement child : advancement.getChildren()) {
            SpongeAdvancementTreeBuilder.applyTree(child, tree);
        }
    }

    @Override
    public AdvancementTree.Builder reset() {
        this.background = "minecraft:textures/gui/advancements/backgrounds/stone.png";
        this.rootAdvancement = null;
        this.name = null;
        this.id = null;
        return this;
    }
}

