/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.advancements.Criterion;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.advancement.DefaultedAdvancementCriterion;
import org.spongepowered.common.advancement.SpongeEmptyCriterion;
import org.spongepowered.common.advancement.SpongeOperatorCriterion;
import org.spongepowered.common.advancement.SpongeScoreCriterion;

public final class SpongeCriterionHelper {
    static AdvancementCriterion build(Class<? extends OperatorCriterion> type, Function<Set<AdvancementCriterion>, AdvancementCriterion> function, AdvancementCriterion criterion, Iterable<AdvancementCriterion> criteria) {
        Preconditions.checkNotNull(criteria, "criteria");
        ArrayList<AdvancementCriterion> builder = new ArrayList<AdvancementCriterion>();
        SpongeCriterionHelper.build(type, criterion, builder);
        for (AdvancementCriterion criterion1 : criteria) {
            SpongeCriterionHelper.build(type, criterion1, builder);
        }
        return builder.isEmpty() ? SpongeEmptyCriterion.INSTANCE : (builder.size() == 1 ? (AdvancementCriterion)builder.get(0) : function.apply(ImmutableSet.copyOf(builder)));
    }

    private static void build(Class<? extends OperatorCriterion> type, AdvancementCriterion criterion, List<AdvancementCriterion> criteria) {
        if (criterion == SpongeEmptyCriterion.INSTANCE) {
            return;
        }
        Preconditions.checkNotNull(criterion, "criterion");
        if (type.isInstance(criterion)) {
            criteria.addAll(((OperatorCriterion)criterion).getCriteria());
        } else {
            criteria.add(criterion);
        }
    }

    static Tuple<Map<String, Criterion>, String[][]> toVanillaCriteriaData(AdvancementCriterion criterion) {
        HashMap<String, Criterion> criteria = new HashMap<String, Criterion>();
        if (criterion == SpongeEmptyCriterion.INSTANCE) {
            return new Tuple<Map<String, Criterion>, String[][]>(criteria, new String[0][0]);
        }
        SpongeCriterionHelper.collectCriteria(criterion, criteria);
        String[][] idsArray = new String[criteria.size()][];
        Iterator it = criteria.values().iterator();
        for (int i = 0; i < criteria.size(); ++i) {
            idsArray[i] = new String[]{((DefaultedAdvancementCriterion)it.next()).getName()};
        }
        return new Tuple<HashMap<String, Criterion>, String[][]>(criteria, idsArray);
    }

    private static void collectCriteria(AdvancementCriterion criterion, Map<String, Criterion> criteria) {
        if (criterion instanceof SpongeOperatorCriterion) {
            ((SpongeOperatorCriterion)criterion).getCriteria().forEach(c2 -> SpongeCriterionHelper.collectCriteria(c2, criteria));
        } else if (criterion instanceof SpongeScoreCriterion) {
            SpongeScoreCriterion scoreCriterion = (SpongeScoreCriterion)criterion;
            String name = criterion.getName();
            for (int i = 0; i < scoreCriterion.getGoal(); ++i) {
                String id = name + "&score_goal_id=" + i;
                criteria.put(id, (Criterion)scoreCriterion.internalCriteria.get(i));
            }
        } else {
            criteria.put(criterion.getName(), (Criterion)criterion);
        }
    }

    private SpongeCriterionHelper() {
    }
}

