/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.advancement.AdvancementType;
import org.spongepowered.api.advancement.AdvancementTypes;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.text.SpongeTexts;

public class SpongeDisplayInfoBuilder
implements DisplayInfo.Builder {
    private AdvancementType advancementType;
    private Text description;
    private Text title;
    private ItemStackSnapshot icon;
    private boolean showToast;
    private boolean announceToChat;
    private boolean hidden;

    public SpongeDisplayInfoBuilder() {
        this.reset();
    }

    @Override
    public DisplayInfo.Builder type(AdvancementType advancementType) {
        Preconditions.checkNotNull(advancementType, "advancementType");
        this.advancementType = advancementType;
        return this;
    }

    @Override
    public DisplayInfo.Builder description(Text description) {
        Preconditions.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    @Override
    public DisplayInfo.Builder title(Text title) {
        Preconditions.checkNotNull(title, "title");
        this.title = title;
        return this;
    }

    @Override
    public DisplayInfo.Builder icon(ItemStackSnapshot itemStackSnapshot) {
        Preconditions.checkNotNull(itemStackSnapshot, "itemStackSnapshot");
        this.icon = itemStackSnapshot;
        return this;
    }

    @Override
    public DisplayInfo.Builder showToast(boolean showToast) {
        this.showToast = showToast;
        return this;
    }

    @Override
    public DisplayInfo.Builder announceToChat(boolean announceToChat) {
        this.announceToChat = announceToChat;
        return this;
    }

    @Override
    public DisplayInfo.Builder hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public org.spongepowered.api.advancement.DisplayInfo build() {
        Preconditions.checkState(this.title != null, "Title has not been set");
        Preconditions.checkState(this.icon != null, "Icon has not been set");
        ITextComponent title = SpongeTexts.toComponent(this.title);
        ITextComponent description = SpongeTexts.toComponent(this.description);
        FrameType frameType = (FrameType)this.advancementType;
        ItemStack icon = (ItemStack)this.icon.createStack();
        return (org.spongepowered.api.advancement.DisplayInfo)new DisplayInfo(icon, title, description, null, frameType, this.showToast, this.announceToChat, this.hidden);
    }

    @Override
    public DisplayInfo.Builder from(org.spongepowered.api.advancement.DisplayInfo value) {
        this.icon = value.getIcon();
        this.description = value.getDescription();
        this.advancementType = value.getType();
        this.announceToChat = value.doesAnnounceToChat();
        this.hidden = value.isHidden();
        this.showToast = value.doesShowToast();
        this.title = value.getTitle();
        return this;
    }

    @Override
    public DisplayInfo.Builder reset() {
        this.icon = null;
        this.description = Text.EMPTY;
        this.advancementType = AdvancementTypes.TASK;
        this.announceToChat = true;
        this.hidden = false;
        this.showToast = true;
        this.title = null;
        return this;
    }
}

