/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTriggerConfiguration;
import org.spongepowered.api.advancement.criteria.trigger.Trigger;
import org.spongepowered.common.advancement.SpongeFilteredTrigger;
import org.spongepowered.common.advancement.SpongeTrigger;

public class SpongeFilteredTriggerBuilder<C extends FilteredTriggerConfiguration>
implements FilteredTrigger.Builder<C> {
    private C config;
    private Trigger<C> type;

    @Override
    public <T extends FilteredTriggerConfiguration> FilteredTrigger.Builder<T> type(Trigger<T> type) {
        Preconditions.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    @Override
    public FilteredTrigger.Builder<C> config(C config) {
        Preconditions.checkNotNull(config, "config");
        this.config = config;
        return this;
    }

    @Override
    public FilteredTrigger<C> build() {
        Preconditions.checkState(this.type != null, "The type must be set");
        Preconditions.checkState(this.config != null, "The config must be set");
        return new SpongeFilteredTrigger((SpongeTrigger)((Object)this.type), (FilteredTriggerConfiguration)this.config);
    }

    @Override
    public FilteredTrigger.Builder<C> from(FilteredTrigger<C> value) {
        this.config = value.getConfiguration();
        this.type = value.getType();
        return this;
    }

    @Override
    public FilteredTrigger.Builder<C> reset() {
        this.config = null;
        this.type = null;
        return this;
    }
}

