/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.advancement.criteria.trigger.FilteredTrigger;
import org.spongepowered.common.advancement.DefaultedAdvancementCriterion;

public class SpongeOperatorCriterion
implements OperatorCriterion,
DefaultedAdvancementCriterion {
    private final String name;
    private final Collection<AdvancementCriterion> criteria;
    @Nullable
    private Collection<AdvancementCriterion> recursiveChildrenCriteria;
    @Nullable
    private Collection<AdvancementCriterion> leafChildrenCriteria;

    SpongeOperatorCriterion(String namePrefix, Collection<AdvancementCriterion> criteria) {
        this.name = namePrefix + Arrays.toString(criteria.stream().map(AdvancementCriterion::getName).toArray(String[]::new));
        this.criteria = ImmutableSet.copyOf(criteria);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<FilteredTrigger<?>> getTrigger() {
        return Optional.empty();
    }

    private Collection<AdvancementCriterion> getAllChildrenCriteria0(boolean onlyLeaves) {
        ImmutableSet.Builder criteria = ImmutableSet.builder();
        if (!onlyLeaves) {
            criteria.add(this);
        }
        for (AdvancementCriterion criterion : this.criteria) {
            if (!(criterion instanceof OperatorCriterion)) continue;
            criteria.addAll(((SpongeOperatorCriterion)criterion).getAllChildrenCriteria0(onlyLeaves));
        }
        return criteria.build();
    }

    private Collection<AdvancementCriterion> getRecursiveChildren() {
        if (this.recursiveChildrenCriteria == null) {
            this.recursiveChildrenCriteria = this.getAllChildrenCriteria0(false);
        }
        return this.recursiveChildrenCriteria;
    }

    @Override
    public Collection<AdvancementCriterion> getCriteria() {
        return this.criteria;
    }

    @Override
    public Collection<AdvancementCriterion> getLeafCriteria() {
        if (this.leafChildrenCriteria == null) {
            this.leafChildrenCriteria = this.getAllChildrenCriteria0(true);
        }
        return this.leafChildrenCriteria;
    }

    @Override
    public Collection<AdvancementCriterion> find(String name) {
        return this.getRecursiveChildren().stream().filter(c2 -> c2.getName().equals(name)).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Optional<AdvancementCriterion> findFirst(String name) {
        return this.getRecursiveChildren().stream().filter(c2 -> c2.getName().equals(name)).findFirst();
    }
}

