/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.advancement.TreeLayout;
import org.spongepowered.api.advancement.TreeLayoutElement;
import org.spongepowered.common.advancement.SpongeAdvancementTree;

public final class SpongeTreeLayout
implements TreeLayout {
    private final SpongeAdvancementTree tree;

    public SpongeTreeLayout(SpongeAdvancementTree tree) {
        this.tree = tree;
    }

    @Override
    public AdvancementTree getTree() {
        return this.tree;
    }

    @Override
    public Collection<TreeLayoutElement> getElements() {
        ImmutableSet.Builder<TreeLayoutElement> elements = ImmutableSet.builder();
        SpongeTreeLayout.collectElements(this.tree.getRootAdvancement(), elements);
        return elements.build();
    }

    private static void collectElements(Advancement advancement, ImmutableSet.Builder<TreeLayoutElement> elements) {
        advancement.getDisplayInfo().ifPresent(displayInfo -> elements.add((Object)((TreeLayoutElement)((Object)displayInfo))));
        advancement.getChildren().forEach(child -> SpongeTreeLayout.collectElements(child, elements));
    }

    @Override
    public Optional<TreeLayoutElement> getElement(Advancement advancement) {
        Optional<AdvancementTree> tree = advancement.getTree();
        if (!tree.isPresent() || !advancement.getDisplayInfo().isPresent() || tree.get() != this.tree) {
            return Optional.empty();
        }
        return Optional.of((TreeLayoutElement)((Object)advancement.getDisplayInfo().get()));
    }
}

