/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.asset;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.net.URL;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.asset.SpongeAsset;

@Singleton
public final class SpongeAssetManager
implements AssetManager {
    public static final String DEFAULT_ASSET_DIR = "assets/";
    public static final ClassLoader CLASS_LOADER = Sponge.class.getClassLoader();

    @Override
    public Optional<Asset> getAsset(Object instance, String name) {
        Preconditions.checkNotNull(instance, "plugin instance");
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkArgument(!name.isEmpty(), "name cannot be empty");
        PluginContainer plugin = Sponge.getPluginManager().fromInstance(instance).get();
        URL url = CLASS_LOADER.getResource(DEFAULT_ASSET_DIR + plugin.getId() + '/' + name);
        if (url == null) {
            return Optional.empty();
        }
        return Optional.of(new SpongeAsset(plugin, url));
    }

    @Override
    public Optional<Asset> getAsset(String name) {
        return this.getAsset(SpongeImpl.getPlugin(), name);
    }
}

