/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.ban;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Instant;
import java.util.Date;
import javax.annotation.Nullable;
import net.minecraft.server.management.UserListBansEntry;
import net.minecraft.server.management.UserListIPBans;
import net.minecraft.server.management.UserListIPBansEntry;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.ban.Ban;
import org.spongepowered.api.util.ban.BanType;
import org.spongepowered.api.util.ban.BanTypes;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.text.SpongeTexts;

public class SpongeBanBuilder
implements Ban.Builder {
    private GameProfile profile;
    private InetAddress address;
    private BanType banType;
    @Nullable
    private Text reason;
    private Instant start = Instant.now();
    @Nullable
    private Instant end;
    @Nullable
    private Text source;

    @Override
    public Ban.Builder profile(GameProfile profile) {
        Preconditions.checkNotNull(profile, "Profile cannot be null!");
        Preconditions.checkState(this.banType == BanTypes.PROFILE, "Cannot set a GameProfile if the BanType is not BanTypes.PROFILE!");
        this.profile = profile;
        return this;
    }

    @Override
    public Ban.Builder address(InetAddress address) {
        Preconditions.checkNotNull(address, "Address cannot be null!");
        Preconditions.checkState(this.banType == BanTypes.IP, "Cannot set an InetAddress if the BanType is not BanTypes.IP!");
        this.address = address;
        return this;
    }

    @Override
    public Ban.Builder type(BanType type) {
        Preconditions.checkNotNull(type, "BanType cannot be null!");
        if (type == BanTypes.IP) {
            this.profile = null;
        } else {
            this.address = null;
        }
        this.banType = type;
        return this;
    }

    @Override
    public Ban.Builder reason(@Nullable Text reason) {
        this.reason = reason;
        return this;
    }

    @Override
    public Ban.Builder startDate(Instant instant) {
        Preconditions.checkNotNull(instant, "Start date cannot be null!");
        this.start = instant;
        return this;
    }

    @Override
    public Ban.Builder expirationDate(@Nullable Instant instant) {
        this.end = instant;
        return this;
    }

    @Override
    public Ban.Builder source(@Nullable CommandSource source) {
        this.source = source == null ? null : Text.of(source.getName());
        return this;
    }

    @Override
    public Ban.Builder source(@Nullable Text source) {
        this.source = source;
        return this;
    }

    @Override
    public Ban build() {
        String sourceName;
        Preconditions.checkState(this.banType != null, "BanType cannot be null!");
        String string = sourceName = this.source != null ? SpongeTexts.toLegacy(this.source) : null;
        if (this.banType == BanTypes.PROFILE) {
            Preconditions.checkState(this.profile != null, "User cannot be null!");
            return (Ban)new UserListBansEntry((com.mojang.authlib.GameProfile)((Object)this.profile), Date.from(this.start), sourceName, this.toDate(this.end), this.reason != null ? SpongeTexts.toLegacy(this.reason) : null);
        }
        Preconditions.checkState(this.address != null, "Address cannot be null!");
        UserListIPBans ipBans = SpongeImpl.getServer().func_184103_al().func_72363_f();
        return (Ban)new UserListIPBansEntry(ipBans.func_152707_c((SocketAddress)new InetSocketAddress(this.address, 0)), Date.from(this.start), sourceName, this.toDate(this.end), this.reason != null ? SpongeTexts.toLegacy(this.reason) : null);
    }

    private Date toDate(Instant instant) {
        return instant == null ? null : Date.from(instant);
    }

    @Override
    public Ban.Builder from(Ban ban) {
        this.reset();
        this.banType = ban.getType();
        if (this.banType.equals(BanTypes.PROFILE)) {
            this.profile = ((Ban.Profile)ban).getProfile();
        } else {
            this.address = ((Ban.Ip)ban).getAddress();
        }
        this.reason = ban.getReason().orElse(null);
        this.start = ban.getCreationDate();
        this.end = ban.getExpirationDate().orElse(null);
        this.source = ban.getBanSource().orElse(null);
        return this;
    }

    @Override
    public Ban.Builder reset() {
        this.profile = null;
        this.address = null;
        this.banType = null;
        this.reason = null;
        this.start = Instant.now();
        this.end = null;
        this.source = null;
        return this;
    }
}

