/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.util.Constants;

public class SpongeBlockStateBuilder
extends AbstractDataBuilder<BlockState>
implements BlockState.Builder {
    private BlockState blockState;

    public SpongeBlockStateBuilder() {
        super(BlockState.class, 1);
    }

    @Override
    public BlockState.Builder blockType(BlockType blockType) {
        this.blockState = Preconditions.checkNotNull(blockType).getDefaultState();
        return this;
    }

    @Override
    public BlockState.Builder add(DataManipulator<?, ?> manipulator) {
        return this.add((ImmutableDataManipulator)manipulator.asImmutable());
    }

    @Override
    public BlockState.Builder add(ImmutableDataManipulator<?, ?> manipulator) {
        Optional optional = this.blockState.with(manipulator);
        if (optional.isPresent()) {
            this.blockState = (BlockState)optional.get();
        }
        return this;
    }

    @Override
    public <V> SpongeBlockStateBuilder add(Key<? extends BaseValue<V>> key, V value) {
        Preconditions.checkNotNull(key, "key");
        this.blockState = this.blockState.with(key, value).orElse(this.blockState);
        return this;
    }

    @Override
    public SpongeBlockStateBuilder from(BlockState holder) {
        this.blockState = holder;
        return this;
    }

    @Override
    public SpongeBlockStateBuilder reset() {
        this.blockState = BlockTypes.STONE.getDefaultState();
        return this;
    }

    @Override
    public BlockState build() {
        return this.blockState;
    }

    @Override
    protected Optional<BlockState> buildContent(DataView container) throws InvalidDataException {
        if (!container.contains(Constants.Block.BLOCK_STATE)) {
            return Optional.empty();
        }
        DataUtil.checkDataExists(container, Constants.Block.BLOCK_STATE);
        try {
            return container.getCatalogType(Constants.Block.BLOCK_STATE, BlockState.class);
        }
        catch (Exception e) {
            throw new InvalidDataException("Could not retrieve a blockstate!", e);
        }
    }
}

