/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.permission.MemorySubjectData;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectData;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.command.CommandPermissions;
import org.spongepowered.common.command.SpongeProxySource;
import org.spongepowered.common.service.permission.base.FixedParentMemorySubjectData;
import org.spongepowered.common.service.permission.base.SpongeBaseSubject;

public final class AndPermissionLevelSubject
extends SpongeBaseSubject {
    private final PermissionService service;
    private final CommandSource delegate;
    private final MemorySubjectData opLevelData;

    public AndPermissionLevelSubject(ICommandSender opLevelSubject, CommandSource delegate) {
        this.delegate = delegate;
        this.service = SpongeImpl.getGame().getServiceManager().provideUnchecked(PermissionService.class);
        this.opLevelData = new FixedParentMemorySubjectData(this.service, delegate.asSubjectReference());
        CommandPermissions.populateMinecraftPermissions(opLevelSubject, this.opLevelData);
        for (Map.Entry entry : ImmutableSet.copyOf(this.opLevelData.getPermissions(SubjectData.GLOBAL_CONTEXT).entrySet())) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            this.opLevelData.setPermission(SubjectData.GLOBAL_CONTEXT, (String)entry.getKey(), Tristate.UNDEFINED);
        }
    }

    @Override
    public PermissionService getService() {
        return this.service;
    }

    @Override
    public String getIdentifier() {
        return this.delegate.getIdentifier();
    }

    @Override
    public Set<Context> getActiveContexts() {
        return this.delegate.getActiveContexts();
    }

    @Override
    public Optional<CommandSource> getCommandSource() {
        return Optional.empty();
    }

    @Override
    public SubjectCollection getContainingCollection() {
        return this.delegate.getContainingCollection();
    }

    @Override
    public SubjectData getSubjectData() {
        return this.delegate.getSubjectData();
    }

    @Override
    public MemorySubjectData getTransientSubjectData() {
        return this.opLevelData;
    }

    @Override
    public boolean hasPermission(Set<Context> contexts, String permission) {
        Tristate value = this.getPermissionValue(contexts, permission);
        if (value == Tristate.UNDEFINED) {
            Subject target = this.delegate;
            while (target instanceof SpongeProxySource) {
                target = ((SpongeProxySource)target).getSubjectDelegate();
            }
            if (target instanceof SubjectBridge) {
                return ((SubjectBridge)((Object)target)).bridge$permDefault(permission).asBoolean();
            }
        }
        return value.asBoolean();
    }
}

