/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.flowpowered.math.GenericMath;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.mixin.core.world.storage.SaveHandlerAccessor;

class ChunkSaveHelper {
    ChunkSaveHelper() {
    }

    public static void writeChunks(File file, boolean logAll) {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            try (JsonWriter writer = new JsonWriter(new FileWriter(file));){
                writer.setIndent("  ");
                writer.beginArray();
                for (World spongeWorld : SpongeImpl.getGame().getServer().getWorlds()) {
                    WorldServer world = (WorldServer)spongeWorld;
                    writer.beginObject();
                    writer.name("name").value(((SaveHandlerAccessor)((WorldServer)spongeWorld).func_72860_G()).accessor$getSaveDirectoryName());
                    writer.name("dimensionId").value(((WorldServerBridge)((Object)spongeWorld)).bridge$getDimensionId());
                    writer.name("players").value(world.field_73010_i.size());
                    writer.name("loadedChunks").value(world.func_72863_F().func_189548_a().size());
                    writer.name("activeChunks").value(world.func_72863_F().func_73152_e());
                    writer.name("entities").value(world.field_72996_f.size());
                    writer.name("tiles").value(world.field_147482_g.size());
                    Object2IntOpenHashMap<ChunkPos> chunkEntityCounts = new Object2IntOpenHashMap<ChunkPos>();
                    chunkEntityCounts.defaultReturnValue(0);
                    Reference2IntOpenHashMap classEntityCounts = new Reference2IntOpenHashMap();
                    classEntityCounts.defaultReturnValue(0);
                    Object2IntOpenHashMap<Entity> entityCollisionCounts = new Object2IntOpenHashMap<Entity>();
                    HashSet<BlockPos> collidingCoords = new HashSet<BlockPos>();
                    for (int i = 0; i < world.field_72996_f.size(); ++i) {
                        BlockPos coords;
                        Entity entity = (Entity)world.field_72996_f.get(i);
                        ChunkPos chunkCoords = new ChunkPos((int)entity.field_70165_t >> 4, (int)entity.field_70161_v >> 4);
                        chunkEntityCounts.put(chunkCoords, chunkEntityCounts.getInt(chunkCoords) + 1);
                        classEntityCounts.put(entity.getClass(), classEntityCounts.getInt(entity.getClass()) + 1);
                        if (entity.func_70046_E() == null || !logAll || collidingCoords.contains(coords = new BlockPos(GenericMath.floor(entity.field_70165_t), GenericMath.floor(entity.field_70163_u), GenericMath.floor(entity.field_70161_v)))) continue;
                        collidingCoords.add(coords);
                        int size = entity.field_70170_p.func_72839_b(entity, entity.func_70046_E().func_72314_b(1.0, 1.0, 1.0)).size();
                        if (size < 5) continue;
                        entityCollisionCounts.put(entity, size);
                    }
                    Object2IntOpenHashMap<ChunkPos> chunkTileCounts = new Object2IntOpenHashMap<ChunkPos>();
                    chunkTileCounts.defaultReturnValue(0);
                    Reference2IntOpenHashMap classTileCounts = new Reference2IntOpenHashMap();
                    classTileCounts.defaultReturnValue(0);
                    writer.name("tiles").beginArray();
                    for (int i = 0; i < world.field_147482_g.size(); ++i) {
                        TileEntity tile = (TileEntity)world.field_147482_g.get(i);
                        if (logAll) {
                            writer.beginObject();
                            writer.name("type").value(tile.getClass().toString());
                            writer.name("x").value(tile.func_174877_v().func_177958_n());
                            writer.name("y").value(tile.func_174877_v().func_177956_o());
                            writer.name("z").value(tile.func_174877_v().func_177952_p());
                            writer.name("isInvalid").value(tile.func_145837_r());
                            writer.name("block").value("" + tile.func_145838_q());
                            writer.endObject();
                        }
                        ChunkPos chunkCoords = new ChunkPos(tile.func_174877_v().func_177958_n() >> 4, tile.func_174877_v().func_177952_p() >> 4);
                        chunkTileCounts.put(chunkCoords, chunkTileCounts.getInt(chunkCoords) + 1);
                        classTileCounts.put(tile.getClass(), classTileCounts.getInt(tile.getClass()) + 1);
                    }
                    writer.endArray();
                    if (logAll) {
                        ChunkSaveHelper.writeChunkCounts(writer, "topEntityColliders", entityCollisionCounts, 20);
                    }
                    ChunkSaveHelper.writeChunkCounts(writer, "entitiesByClass", classEntityCounts);
                    ChunkSaveHelper.writeChunkCounts(writer, "entitiesByChunk", chunkEntityCounts);
                    ChunkSaveHelper.writeChunkCounts(writer, "tilesByClass", classTileCounts);
                    ChunkSaveHelper.writeChunkCounts(writer, "tilesByChunk", chunkTileCounts);
                    writer.endObject();
                }
                writer.endArray();
            }
        }
        catch (Throwable throwable) {
            SpongeImpl.getLogger().error("Could not save chunk info report to " + file);
        }
    }

    private static <T> void writeChunkCounts(JsonWriter writer, String name, Object2IntMap<T> map) throws IOException {
        ChunkSaveHelper.writeChunkCounts(writer, name, map, 0);
    }

    private static <T> void writeChunkCounts(JsonWriter writer, String name, Object2IntMap<T> map, int max) throws IOException {
        ArrayList<T> sortedCoords = new ArrayList<T>(map.keySet());
        sortedCoords.sort((s1, s2) -> map.getInt(s2) - map.getInt(s1));
        int i = 0;
        writer.name(name).beginArray();
        for (Object key : sortedCoords) {
            if (max > 0 && i++ > max) break;
            if ((Integer)map.get(key) < 5) continue;
            writer.beginObject();
            writer.name("key").value(key.toString());
            writer.name("count").value((Number)map.get(key));
            writer.endObject();
        }
        writer.endArray();
    }

    private static <T> void writeChunkCounts(JsonWriter writer, String name, Reference2IntMap<T> map) throws IOException {
        ChunkSaveHelper.writeChunkCounts(writer, name, map, 0);
    }

    private static <T> void writeChunkCounts(JsonWriter writer, String name, Reference2IntMap<T> map, int max) throws IOException {
        ArrayList<T> sortedCoords = new ArrayList<T>(map.keySet());
        sortedCoords.sort((s1, s2) -> map.getInt(s2) - map.getInt(s1));
        int i = 0;
        writer.name(name).beginArray();
        for (Object key : sortedCoords) {
            if (max > 0 && i++ > max) break;
            if ((Integer)map.get(key) < 5) continue;
            writer.beginObject();
            writer.name("key").value(key.toString());
            writer.name("count").value((Number)map.get(key));
            writer.endObject();
        }
        writer.endArray();
    }
}

