/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandPermissionException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.InvocationCommandException;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.command.CommandHandlerBridge;
import org.spongepowered.common.bridge.command.ICommandBridge;
import org.spongepowered.common.command.WrapperICommandSender;
import org.spongepowered.common.mixin.core.command.CommandHandlerAccessor;
import org.spongepowered.common.text.translation.SpongeTranslation;
import org.spongepowered.common.util.VecHelper;

public class MinecraftCommandWrapper
implements CommandCallable {
    private static final String TRANSLATION_NO_PERMISSION = "commands.generic.permission";
    private final PluginContainer owner;
    protected final ICommand command;
    private static final ThreadLocal<Deque<Throwable>> commandErrors = new ThreadLocal<Deque<Throwable>>(){

        @Override
        protected Deque<Throwable> initialValue() {
            return new LinkedList<Throwable>();
        }
    };
    private static final Exception noError = new Exception();

    public MinecraftCommandWrapper(PluginContainer owner, ICommand command) {
        this.owner = owner;
        this.command = command;
        if (this.command instanceof ICommandBridge) {
            ((ICommandBridge)this.command).bridge$updateNamespacedAlias(this.owner.getId());
        }
    }

    private String[] splitArgs(String arguments) {
        return arguments.isEmpty() ? new String[]{} : arguments.split(" ", -1);
    }

    @Override
    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        if (!this.testPermission(source)) {
            throw new CommandPermissionException(Text.of(SpongeImpl.getGame().getRegistry().getTranslationById(TRANSLATION_NO_PERMISSION).get(), new Object[0]));
        }
        CommandHandler handler = (CommandHandler)SpongeImpl.getServer().func_71187_D();
        ICommandSender mcSender = WrapperICommandSender.of(source);
        String[] splitArgs = this.splitArgs(arguments);
        int usernameIndex = 0;
        try {
            usernameIndex = ((CommandHandlerAccessor)handler).accessor$getUsernameIndex(this.command, splitArgs);
        }
        catch (net.minecraft.command.CommandException e) {
            throw new RuntimeException(e);
        }
        int successCount = 0;
        if (!this.throwEvent(mcSender, splitArgs)) {
            return CommandResult.empty();
        }
        int affectedEntities = 1;
        if (usernameIndex > -1) {
            List list = null;
            try {
                list = EntitySelector.func_179656_b((ICommandSender)mcSender, (String)splitArgs[usernameIndex], Entity.class);
            }
            catch (net.minecraft.command.CommandException e) {
                throw new RuntimeException(e);
            }
            String previousNameVal = splitArgs[usernameIndex];
            affectedEntities = list.size();
            ((CommandHandlerBridge)handler).bridge$setExpandedSelector(true);
            for (Entity entity : list) {
                splitArgs[usernameIndex] = entity.func_189512_bd();
                if (!this.tryExecute(handler, mcSender, splitArgs, arguments)) continue;
                ++successCount;
            }
            splitArgs[usernameIndex] = previousNameVal;
            ((CommandHandlerBridge)handler).bridge$setExpandedSelector(false);
        } else if (this.tryExecute(handler, mcSender, splitArgs, arguments)) {
            ++successCount;
        }
        return CommandResult.builder().affectedEntities(affectedEntities).successCount(successCount).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryExecute(CommandHandler handler, ICommandSender mcSender, String[] splitArgs, String arguments) {
        commandErrors.get().push(noError);
        try {
            boolean bl2 = ((CommandHandlerAccessor)handler).accessor$tryExecuteCommand(mcSender, splitArgs, this.command, arguments);
            return bl2;
        }
        finally {
            Throwable error = commandErrors.get().pop();
            if (error != noError) {
                throw new RuntimeException(error);
            }
        }
    }

    protected boolean throwEvent(ICommandSender sender, String[] args) throws InvocationCommandException {
        return true;
    }

    public int getPermissionLevel() {
        return this.command instanceof CommandBase ? ((CommandBase)this.command).func_82362_a() : -1;
    }

    public String getCommandPermission() {
        return this.owner.getId().toLowerCase() + ".command." + this.command.func_71517_b();
    }

    public PluginContainer getOwner() {
        return this.owner;
    }

    @Override
    public boolean testPermission(CommandSource source) {
        if (!SpongeImpl.getGlobalConfigAdapter().getConfig().getCommands().isEnforcePermissionChecksOnNonSpongeCommands() || source.hasPermission(this.getCommandPermission())) {
            ICommandSender sender = WrapperICommandSender.of(source);
            return this.command.func_184882_a(sender.func_184102_h(), sender);
        }
        return false;
    }

    @Override
    public Optional<Text> getShortDescription(CommandSource source) {
        return this.getHelp(source);
    }

    @Override
    public Optional<Text> getHelp(CommandSource source) {
        String translation = this.command.func_71518_a(WrapperICommandSender.of(source));
        if (translation == null) {
            return Optional.empty();
        }
        return Optional.of(Text.of(new SpongeTranslation(translation), new Object[0]));
    }

    @Override
    public Text getUsage(CommandSource source) {
        ICommandSender mcSender = WrapperICommandSender.of(source);
        String usage = this.command.func_71518_a(mcSender);
        if (usage == null) {
            return Text.of();
        }
        Translation translation = SpongeImpl.getGame().getRegistry().getTranslationById(usage).get();
        usage = source instanceof Player ? translation.get(source.getLocale()) : translation.get(Locale.getDefault());
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(usage.split(" ")));
        parts.removeAll(Collections.singleton("/" + this.command.func_71517_b()));
        StringBuilder out = new StringBuilder();
        for (String s : parts) {
            out.append(s);
            out.append(" ");
        }
        return Text.of(out.toString().trim());
    }

    @Override
    public List<String> getSuggestions(CommandSource source, String arguments, @Nullable Location<World> targetPosition) throws CommandException {
        if (!this.testPermission(source)) {
            return ImmutableList.of();
        }
        List suggestions = this.command.func_184883_a(SpongeImpl.getServer(), WrapperICommandSender.of(source), arguments.split(" ", -1), targetPosition == null ? null : VecHelper.toBlockPos(targetPosition));
        if (suggestions == null) {
            return ImmutableList.of();
        }
        return suggestions;
    }

    public List<String> getNames() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this.command.func_71517_b())).addAll((Iterable)this.command.func_71514_a())).build();
    }

    public static void setError(Throwable error) {
        Preconditions.checkNotNull(error);
        Throwable old = commandErrors.get().peek();
        if (old == null) {
            throw new IllegalStateException();
        }
        if (old == noError) {
            commandErrors.get().pop();
            commandErrors.get().push(error);
        }
    }

    public boolean suppressDuplicateAlias(String alias) {
        return false;
    }
}

