/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.command;

import co.aikar.timings.Timings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandMapping;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.ChildCommandElementExecutor;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.util.SpongeApiTranslationHelper;
import org.spongepowered.api.util.StartsWithPredicate;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.OwnershipTrackedBridge;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.world.DimensionTypeBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.command.ChunkSaveHelper;
import org.spongepowered.common.command.SpongeCommandDispatcher;
import org.spongepowered.common.command.SpongeCommandManager;
import org.spongepowered.common.command.args.FilteredPluginsCommandElement;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.MetricsCategory;
import org.spongepowered.common.config.type.ConfigBase;
import org.spongepowered.common.config.type.DimensionConfig;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.config.type.TrackerConfig;
import org.spongepowered.common.config.type.WorldConfig;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.mixin.core.world.WorldAccessor;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimingsFactory;
import org.spongepowered.common.util.SpongeCommonTranslationHelper;
import org.spongepowered.common.util.SpongeHooks;

public class SpongeCommandFactory {
    public static final String INDENT = "    ";
    public static final String LONG_INDENT = "        ";
    public static final List<String> CONTAINER_LIST_STATICS = Lists.newArrayList("minecraft", "mcp", "spongeapi", "sponge");
    protected static final Text SEPARATOR_TEXT = Text.of(", ");
    static final Text INDENT_TEXT = Text.of("    ");
    static final Text NEWLINE_TEXT = Text.NEW_LINE;
    static final Text LIST_ITEM_TEXT = Text.of(TextColors.GRAY, "- ");
    static final Text UNKNOWN = Text.of("UNKNOWN");
    private static final Text ENABLED_TEXT = Text.of(TextColors.GREEN, "enabled");
    private static final Text DISABLED_TEXT = Text.of(TextColors.RED, "disabled");
    private static final Text FAILED_TEXT = Text.of(TextColors.RED, "Failed to set config entry.");
    private static final String JAVA_VENDOR = System.getProperty("java.vendor");
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private static final String JAVA_ARCH = System.getProperty("sun.arch.data.model", "UNKNOWN");
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_VERSION = System.getProperty("os.version");
    private static final String OS_ARCH = System.getProperty("os.arch", "UNKNOWN");
    private static final CommandElement DUMMY_ELEMENT = new CommandElement(Text.EMPTY){

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            throw args.createError(SpongeCommonTranslationHelper.t("No subcommand was specified", new Object[0]));
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            return ImmutableList.of();
        }
    };
    private static final DecimalFormat THREE_DECIMAL_DIGITS_FORMATTER = new DecimalFormat("########0.000");
    private static final Comparator<CommandMapping> COMMAND_COMPARATOR = Comparator.comparing(CommandMapping::getPrimaryAlias);
    private static final Text PAGE_KEY = Text.of("page");
    private static final Text COMMAND_KEY = Text.of("command");
    private static final Text PLUGIN_KEY = Text.of("plugin");
    private static final Text COLLECTION_STATE_KEY = Text.of("enabled");
    private static final CommandElement HELP_COMMAND_ARGUMENT = new CommandElement(COMMAND_KEY){

        @Override
        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String input = args.next();
            Optional<? extends CommandMapping> cmd = SpongeImpl.getCommandManager().get(input, source, SpongeCommandDispatcher.ON_DISCOVERY);
            if (!cmd.isPresent()) {
                throw args.createError(SpongeApiTranslationHelper.t("No such command: ", input));
            }
            return cmd.orElse(null);
        }

        @Override
        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            String prefix = args.nextIfPresent().orElse("");
            return SpongeCommandFactory.commandsStr(src).stream().filter(new StartsWithPredicate(prefix)).collect(ImmutableList.toImmutableList());
        }
    };
    private static final Text NOT_FOUND = Text.of("notFound");
    private static final Map<String, Tristate> COLLECTION_STATE_CHOICES = ImmutableMap.builder().put("true", Tristate.TRUE).put("on", Tristate.TRUE).put("enable", Tristate.TRUE).put("enabled", Tristate.TRUE).put("false", Tristate.FALSE).put("off", Tristate.FALSE).put("disable", Tristate.FALSE).put("disabled", Tristate.FALSE).put("default", Tristate.UNDEFINED).put("undefine", Tristate.UNDEFINED).put("undefined", Tristate.UNDEFINED).build();
    private static final Text IMPLEMENTATION_NAME = Text.of(TextColors.YELLOW, TextStyles.BOLD, Sponge.getPlatform().getContainer(Platform.Component.IMPLEMENTATION).getName());

    public static CommandSpec createSpongeCommand() {
        ChildCommandElementExecutor trackerFlagChildren = new ChildCommandElementExecutor(null);
        ChildCommandElementExecutor flagChildren = new ChildCommandElementExecutor(trackerFlagChildren, DUMMY_ELEMENT, true);
        ChildCommandElementExecutor nonFlagChildren = new ChildCommandElementExecutor(flagChildren, DUMMY_ELEMENT, true);
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeVersionCommand(), "version");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeBlockInfoCommand(), "blockInfo");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeEntityInfoCommand(), "entityInfo");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeAuditCommand(), "audit");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeHeapCommand(), "heap");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongePluginsCommand(), "plugins");
        nonFlagChildren.register(SpongeCommandFactory.createSpongeTimingsCommand(), "timings");
        nonFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeWhichCommand(), "which");
        nonFlagChildren.register(SpongeCommandFactory.createSpongeMetricsCommand(), "metrics");
        flagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeChunksCommand(), "chunks");
        flagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeTPSCommand(), "tps");
        trackerFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeConfigCommand(), "config");
        trackerFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeReloadCommand(), "reload");
        trackerFlagChildren.register((CommandCallable)SpongeCommandFactory.createSpongeSaveCommand(), "save");
        SpongeImplHooks.registerAdditionalCommands(flagChildren, nonFlagChildren);
        return CommandSpec.builder().description(Text.of("General Sponge command")).extendedDescription(Text.of("commands:\n", INDENT, SpongeCommandFactory.title("chunks"), LONG_INDENT, "Prints chunk data for a specific dimension or world(s)\n", INDENT, SpongeCommandFactory.title("conf"), LONG_INDENT, "Configure sponge settings\n", INDENT, SpongeCommandFactory.title("heap"), LONG_INDENT, "Dump live JVM heap\n", INDENT, SpongeCommandFactory.title("reload"), LONG_INDENT, "Reloads a global, dimension, or world config\n", INDENT, SpongeCommandFactory.title("save"), LONG_INDENT, "Saves a global, dimension, or world config\n", INDENT, SpongeCommandFactory.title("version"), LONG_INDENT, "Prints current Sponge version\n", INDENT, SpongeCommandFactory.title("audit"), LONG_INDENT, "Audit mixin classes for implementation\n", INDENT, SpongeCommandFactory.title("plugins"), LONG_INDENT, "List currently installed plugins\n", INDENT, SpongeCommandFactory.title("which"), LONG_INDENT, "List plugins that own a specific command\n", INDENT, SpongeCommandFactory.title("tps"), LONG_INDENT, "Provides TPS (ticks per second) data for loaded worlds\n", INDENT, SpongeCommandFactory.title("metrics"), LONG_INDENT, "Gets or sets permission for metric plugins to operate\n", SpongeImplHooks.getAdditionalCommandDescriptions())).arguments(GenericArguments.firstParsing(nonFlagChildren, GenericArguments.flags().flag("-global", "g").valueFlag(GenericArguments.world(Text.of("world")), "-world", "w").valueFlag(GenericArguments.dimension(Text.of("dimension")), "-dimension", "d").buildWith(flagChildren), GenericArguments.flags().flag("-global", "g").valueFlag(GenericArguments.world(Text.of("world")), "-world", "w").valueFlag(GenericArguments.dimension(Text.of("dimension")), "-dimension", "d").flag("-tracker", "t").buildWith(trackerFlagChildren))).executor(nonFlagChildren).build();
    }

    private static CommandSpec createSpongeChunksCommand() {
        return CommandSpec.builder().description(Text.of("Print chunk information, optionally dump")).arguments(GenericArguments.optional(GenericArguments.seq(GenericArguments.literal((Text)Text.of("dump"), "dump"), GenericArguments.optional(GenericArguments.literal((Text)Text.of("dump-all"), "all"))))).permission("sponge.command.chunks").executor(new ConfigUsingExecutor(true){

            @Override
            public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
                CommandResult res = super.execute(src, args);
                if (args.hasAny("dump")) {
                    File file = new File(new File(new File("."), "chunk-dumps"), "chunk-info-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(Instant.now()) + "-server.txt");
                    src.sendMessage(Text.of("Writing chunk info to: ", file));
                    ChunkSaveHelper.writeChunks(file, args.hasAny("dump-all"));
                    src.sendMessage(Text.of("Chunk info complete"));
                }
                return res;
            }

            @Override
            protected Text processGlobal(SpongeConfig<GlobalConfig> config, CommandSource source, CommandContext args) throws CommandException {
                for (World world : SpongeImpl.getGame().getServer().getWorlds()) {
                    source.sendMessage(Text.of("World ", Text.of(TextStyles.BOLD, world.getName()), this.getChunksInfo((WorldServer)world)));
                }
                return Text.of("Printed chunk info for all worlds ");
            }

            @Override
            protected Text processDimension(SpongeConfig<DimensionConfig> config, DimensionType dim, CommandSource source, CommandContext args) throws CommandException {
                SpongeImpl.getGame().getServer().getWorlds().stream().filter(world -> world.getDimension().getType().equals(dim)).forEach(world -> source.sendMessage(Text.of("World ", Text.of(TextStyles.BOLD, world.getName()), this.getChunksInfo((WorldServer)world))));
                return Text.of("Printed chunk info for all worlds in dimension ", dim.getName());
            }

            @Override
            protected Text processWorld(SpongeConfig<WorldConfig> config, World world, CommandSource source, CommandContext args) throws CommandException {
                return this.getChunksInfo((WorldServer)world);
            }

            protected Text key(Object text) {
                return Text.of(TextColors.GOLD, text);
            }

            protected Text value(Object text) {
                return Text.of(TextColors.GRAY, text);
            }

            protected Text getChunksInfo(WorldServer worldserver) {
                if (((WorldBridge)worldserver).bridge$isFake() || worldserver.func_72912_H() == null) {
                    return Text.of(NEWLINE_TEXT, "Fake world");
                }
                return Text.of(NEWLINE_TEXT, this.key("DimensionId: "), this.value(((WorldServerBridge)worldserver).bridge$getDimensionId()), NEWLINE_TEXT, this.key("Loaded chunks: "), this.value(worldserver.func_72863_F().func_73152_e()), NEWLINE_TEXT, this.key("Active chunks: "), this.value(worldserver.func_72863_F().func_189548_a().size()), NEWLINE_TEXT, this.key("Entities: "), this.value(worldserver.field_72996_f.size()), NEWLINE_TEXT, this.key("Tile Entities: "), this.value(worldserver.field_147482_g.size()), NEWLINE_TEXT, this.key("Removed Entities:"), this.value(((WorldAccessor)worldserver).accessor$getUnloadedEntityList().size()), NEWLINE_TEXT, this.key("Removed Tile Entities: "), this.value(((WorldAccessor)worldserver).accessor$getTileEntitiesToBeRemoved()), NEWLINE_TEXT);
            }
        }).build();
    }

    private static CommandSpec createSpongeConfigCommand() {
        return CommandSpec.builder().description(Text.of("Inspect the Sponge config")).arguments(GenericArguments.seq(GenericArguments.string(Text.of("key")), GenericArguments.optional(GenericArguments.string(Text.of("value"))))).permission("sponge.command.config").executor(new ConfigIncludingTrackerUsingExecutor(false){

            @Override
            protected Text process(SpongeConfig<? extends ConfigBase> config, CommandSource source, CommandContext args) throws CommandException {
                Optional key = args.getOne("key");
                Optional value = args.getOne("value");
                if (config.getSetting((String)key.get()) == null || config.getSetting((String)key.get()).isVirtual()) {
                    throw new CommandException(Text.of("Key ", Text.builder((String)key.get()).color(TextColors.GREEN).build(), " is not valid"));
                }
                if (value.isPresent()) {
                    config.updateSetting((String)key.get(), value.get());
                    return Text.builder().append(Text.of(TextColors.GOLD, key), Text.of(" set to "), SpongeCommandFactory.title((String)value.get())).build();
                }
                return Text.builder().append(Text.of(TextColors.GOLD, key), Text.of(" is "), SpongeCommandFactory.title(String.valueOf(config.getSetting((String)key.get()).getValue()))).build();
            }
        }).build();
    }

    private static CommandSpec createSpongeReloadCommand() {
        return CommandSpec.builder().description(Text.of("Reload the Sponge game")).permission("sponge.command.reload").executor(new ConfigIncludingTrackerUsingExecutor(false){

            @Override
            protected Text process(SpongeConfig<? extends ConfigBase> config, CommandSource source, CommandContext args) throws CommandException {
                config.load();
                SpongeHooks.refreshActiveConfigs();
                return Text.of("Reloaded configuration");
            }
        }).build();
    }

    private static CommandSpec createSpongeSaveCommand() {
        return CommandSpec.builder().description(Text.of("Save the configuration")).permission("sponge.command.save").executor(new ConfigIncludingTrackerUsingExecutor(false){

            @Override
            protected Text process(SpongeConfig<? extends ConfigBase> config, CommandSource source, CommandContext args) throws CommandException {
                config.save();
                return Text.of("Saved");
            }
        }).build();
    }

    private static CommandSpec createSpongeHeapCommand() {
        return CommandSpec.builder().description(Text.of("Generate a dump of the Sponge heap")).permission("sponge.command.heap").executor((src, args) -> {
            File file = new File(new File(new File("."), "dumps"), "heap-dump-" + DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss").format(LocalDateTime.now()) + "-server.hprof");
            src.sendMessage(Text.of("Writing JVM heap data to: ", file));
            SpongeHooks.dumpHeap(file, true);
            src.sendMessage(Text.of("Heap dump complete"));
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeVersionCommand() {
        return CommandSpec.builder().description(Text.of("Display Sponge's current version")).permission("sponge.command.version").executor((src, args) -> {
            Text.Builder builder = Text.builder().append(IMPLEMENTATION_NAME);
            for (PluginContainer container : SpongeImpl.getInternalPlugins()) {
                builder.append(NEWLINE_TEXT, Text.of(TextColors.GRAY, INDENT + container.getName(), ": "), container.getVersion().isPresent() ? Text.of(container.getVersion().get()) : UNKNOWN);
            }
            String javaArch = !"UNKNOWN".equalsIgnoreCase(JAVA_ARCH) ? JAVA_ARCH + "-bit" : JAVA_ARCH;
            builder.append(NEWLINE_TEXT, Text.of(TextColors.GRAY, "    JVM", ": "), Text.of(JAVA_VERSION + "/" + javaArch + " (" + JAVA_VENDOR + ")"));
            builder.append(NEWLINE_TEXT, Text.of(TextColors.GRAY, "    OS", ": "), Text.of(OS_NAME + " (" + OS_VERSION + "/" + OS_ARCH + ")"));
            src.sendMessage(builder.build());
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeBlockInfoCommand() {
        return CommandSpec.builder().description(Text.of("Display the tracked information of the Block you are looking at.")).permission("sponge.command.blockinfo").executor((src, args) -> {
            if (!(src instanceof Player)) {
                src.sendMessage(Text.of(TextColors.RED, "Players must execute this command!"));
                return CommandResult.empty();
            }
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)((Player)src);
            RayTraceResult rayTraceResult = EntityUtil.rayTraceFromEntity((net.minecraft.entity.Entity)entityPlayerMP, 5.0, 1.0f);
            if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
                src.sendMessage(Text.of(TextColors.RED, TextStyles.ITALIC, "Failed to find a block! Please execute the command when looking at a block!"));
                return CommandResult.empty();
            }
            WorldServer worldServer = (WorldServer)entityPlayerMP.field_70170_p;
            Chunk chunk = worldServer.func_175726_f(rayTraceResult.func_178782_a());
            ChunkBridge mixinChunk = (ChunkBridge)chunk;
            IBlockState blockState = worldServer.func_180495_p(rayTraceResult.func_178782_a());
            BlockState spongeState = (BlockState)blockState;
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Block Type: ", TextColors.BLUE, TextStyles.RESET, spongeState.getId()));
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Block Owner: ", TextColors.BLUE, TextStyles.RESET, mixinChunk.bridge$getBlockOwner(rayTraceResult.func_178782_a())));
            src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Block Notifier: ", TextColors.BLUE, TextStyles.RESET, mixinChunk.bridge$getBlockNotifier(rayTraceResult.func_178782_a())));
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeEntityInfoCommand() {
        return CommandSpec.builder().description(Text.of("Display the tracked information of the Entity you are looking at.")).permission("sponge.command.entityinfo").executor((src, args) -> {
            if (!(src instanceof Player)) {
                return CommandResult.empty();
            }
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)((Player)src);
            RayTraceResult rayTraceResult = EntityUtil.rayTraceFromEntity((net.minecraft.entity.Entity)entityPlayerMP, 5.0, 1.0f, true);
            if (rayTraceResult.field_72313_a != RayTraceResult.Type.ENTITY) {
                src.sendMessage(Text.of(TextColors.RED, TextStyles.ITALIC, "Failed to find an entity! Please execute the command when looking at an entity!"));
                return CommandResult.empty();
            }
            net.minecraft.entity.Entity entityHit = rayTraceResult.field_72308_g;
            EntityBridge mixinEntity = (EntityBridge)entityHit;
            Entity spongeEntity = (Entity)entityHit;
            Text.Builder builder = Text.builder();
            builder.append(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "EntityType: ")).append(Text.of(TextColors.BLUE, TextStyles.RESET, spongeEntity.getType().getId()));
            src.sendMessage(builder.build());
            if (entityHit instanceof OwnershipTrackedBridge) {
                ((OwnershipTrackedBridge)entityHit).tracked$getOwnerReference().ifPresent(owner -> src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Owner: ", TextColors.BLUE, TextStyles.RESET, owner)));
                ((OwnershipTrackedBridge)entityHit).tracked$getNotifierReference().ifPresent(notifier -> src.sendMessage(Text.of(TextColors.DARK_GREEN, TextStyles.BOLD, "Notifier: ", TextColors.BLUE, TextStyles.RESET, notifier)));
            }
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeAuditCommand() {
        return CommandSpec.builder().description(Text.of("Audit Mixin classes for implementation")).permission("sponge.command.audit").executor((src, args) -> {
            MixinEnvironment.getCurrentEnvironment().audit();
            return CommandResult.empty();
        }).build();
    }

    public static Text title(String title) {
        return Text.of(TextColors.GREEN, title);
    }

    public static Text hl(String toHighlight) {
        return Text.of(TextColors.DARK_GREEN, toHighlight);
    }

    private static CommandSpec createSpongePluginsCommand() {
        return CommandSpec.builder().description(Text.of("List currently installed plugins")).permission("sponge.command.plugins").arguments(GenericArguments.optionalWeak(GenericArguments.literal((Text)Text.of("reload"), "reload")), GenericArguments.optional(new FilteredPluginsCommandElement((Text)Text.of("plugin"), SpongeImplHooks.getPluginFilterPredicate()))).executor((src, args) -> {
            if (args.hasAny("reload") && src.hasPermission("sponge.command.plugins.reload")) {
                Sponge.getCauseStackManager().pushCause(src);
                if (args.hasAny("plugin")) {
                    PluginContainer plugin = (PluginContainer)args.getOne("plugin").orElseThrow(() -> new CommandException(Text.of("More than one plugin was matched by the input, please be more specific.")));
                    src.sendMessage(Text.of("Sending reload event to " + plugin.getId() + ". Please wait."));
                    ((SpongeEventManager)Sponge.getEventManager()).post((Event)SpongeEventFactory.createGameReloadEvent(Sponge.getCauseStackManager().getCurrentCause()), plugin);
                } else {
                    src.sendMessage(Text.of("Sending reload event to all plugins. Please wait."));
                    SpongeImpl.postEvent(SpongeEventFactory.createGameReloadEvent(Sponge.getCauseStackManager().getCurrentCause()));
                }
                Sponge.getCauseStackManager().popCause();
                src.sendMessage(Text.of("Reload complete!"));
            } else if (args.hasAny("plugin")) {
                SpongeCommandFactory.sendContainerMeta(src, args, "plugin");
            } else {
                Collection<PluginContainer> containers = SpongeImpl.getGame().getPluginManager().getPlugins();
                ArrayList sortedContainers = new ArrayList();
                CONTAINER_LIST_STATICS.forEach(containerId -> containers.stream().filter(container -> container.getId().equalsIgnoreCase((String)containerId)).findFirst().ifPresent(sortedContainers::add));
                containers.stream().filter(SpongeImplHooks.getPluginFilterPredicate()).sorted(Comparator.comparing(PluginContainer::getName)).forEachOrdered(sortedContainers::add);
                if (src instanceof Player) {
                    ArrayList<Text> containerList = new ArrayList<Text>();
                    PaginationList.Builder builder = PaginationList.builder();
                    builder.title(Text.of(TextColors.YELLOW, "Plugins", TextColors.WHITE, " (", sortedContainers.size(), ")")).padding(Text.of(TextColors.DARK_GREEN, "="));
                    for (PluginContainer container : sortedContainers) {
                        Text.Builder containerBuilder = Text.builder().append(Text.of(TextColors.RESET, " - ", TextColors.GREEN, container.getName())).onClick(TextActions.runCommand("/sponge:sponge plugins " + container.getId())).onHover(TextActions.showText(Text.of(TextColors.RESET, "ID: ", container.getId(), Text.NEW_LINE, "Version: ", container.getVersion().orElse("Unknown"))));
                        containerList.add(containerBuilder.build());
                    }
                    builder.contents(containerList).build().sendTo(src);
                } else {
                    Text.Builder builder = Text.builder();
                    builder.append(Text.of(TextColors.YELLOW, "Plugins", TextColors.WHITE, " (", sortedContainers.size(), "): "));
                    boolean first = true;
                    for (PluginContainer container : sortedContainers) {
                        if (!first) {
                            builder.append(SEPARATOR_TEXT);
                        }
                        first = false;
                        builder.append(Text.of(TextColors.GREEN, container.getName()));
                    }
                    src.sendMessage(builder.build());
                }
            }
            return CommandResult.success();
        }).build();
    }

    public static void appendPluginMeta(Text.Builder builder, String key, Optional<?> value) {
        if (value.isPresent()) {
            SpongeCommandFactory.appendPluginMeta(builder, key, value.get());
        }
    }

    public static void appendPluginMeta(Text.Builder builder, String key, Object value) {
        builder.append(NEWLINE_TEXT, INDENT_TEXT, SpongeCommandFactory.title(key + ": "), Text.of(value));
    }

    public static void sendContainerMeta(CommandSource src, CommandContext args, String argumentName) {
        for (PluginContainer container : args.getAll(argumentName)) {
            Text.Builder builder = Text.builder().append(SpongeCommandFactory.title(container.getName()));
            container.getVersion().ifPresent(version -> builder.append(Text.of(" v" + version)));
            SpongeCommandFactory.appendPluginMeta(builder, "ID", container.getId());
            SpongeCommandFactory.appendPluginMeta(builder, "Description", container.getDescription());
            SpongeCommandFactory.appendPluginMeta(builder, "URL", container.getUrl().map(url -> {
                ClickAction.OpenUrl action = null;
                try {
                    action = TextActions.openUrl(new URL((String)url));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return Text.builder(url).onClick((ClickAction)action);
            }));
            if (!container.getAuthors().isEmpty()) {
                SpongeCommandFactory.appendPluginMeta(builder, "Authors", String.join((CharSequence)", ", container.getAuthors()));
            }
            SpongeCommandFactory.appendPluginMeta(builder, "Main class", container.getInstance().map(instance -> instance.getClass().getCanonicalName()));
            src.sendMessage(builder.build());
        }
    }

    private static CommandCallable createSpongeTimingsCommand() {
        return CommandSpec.builder().permission("sponge.command.timings").description(Text.of("Manages Sponge Timings data to see performance of the server.")).child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.reset();
            src.sendMessage(Text.of("Timings reset"));
            return CommandResult.success();
        }).build(), "reset").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.generateReport(src);
            return CommandResult.success();
        }).build(), "report", "paste").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            Timings.setTimingsEnabled(true);
            src.sendMessage(Text.of("Enabled Timings & Reset"));
            return CommandResult.success();
        }).build(), "on").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            Timings.setTimingsEnabled(false);
            src.sendMessage(Text.of("Disabled Timings"));
            return CommandResult.success();
        }).build(), "off").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.setVerboseTimingsEnabled(true);
            src.sendMessage(Text.of("Enabled Verbose Timings"));
            return CommandResult.success();
        }).build(), "verbon").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            Timings.setVerboseTimingsEnabled(false);
            src.sendMessage(Text.of("Disabled Verbose Timings"));
            return CommandResult.success();
        }).build(), "verboff").child((CommandCallable)CommandSpec.builder().executor((src, args) -> {
            if (!Timings.isTimingsEnabled()) {
                src.sendMessage(Text.of("Please enable timings by typing /sponge timings on"));
                return CommandResult.empty();
            }
            src.sendMessage(Text.of("Timings cost: " + SpongeTimingsFactory.getCost()));
            return CommandResult.success();
        }).build(), "cost").build();
    }

    private static CommandSpec createSpongeWhichCommand() {
        return CommandSpec.builder().permission("sponge.command.which").description(Text.of("List plugins that own a specific command")).arguments(GenericArguments.choices((Text)Text.of("command"), () -> Sponge.getCommandManager().getAll().keySet(), Function.identity())).executor((src, args) -> {
            SpongeCommandManager mgr = SpongeImpl.getCommandManager();
            String commandName = (String)args.getOne("command").get();
            CommandMapping primary = mgr.get(commandName, src, SpongeCommandDispatcher.ON_DISCOVERY).orElseThrow(() -> new CommandException(Text.of("Invalid command ", commandName)));
            Set<? extends CommandMapping> all = mgr.getAll(commandName);
            src.sendMessage(Text.of(SpongeCommandFactory.title("Primary: "), "Aliases ", SpongeCommandFactory.hl(primary.getAllAliases().toString()), " owned by ", SpongeCommandFactory.hl(mgr.getOwner(primary).map(PluginContainer::getName).orElse("unknown"))));
            if (all.size() > 1 || all.iterator().next() != primary) {
                src.sendMessage(SpongeCommandFactory.title("Others:"));
                all.stream().filter(map -> !map.equals(primary)).forEach(mapping -> src.sendMessage(Text.of(LIST_ITEM_TEXT, "Aliases ", SpongeCommandFactory.hl(mapping.getAllAliases().toString()), " owned by ", SpongeCommandFactory.hl(mgr.getOwner((CommandMapping)mapping).map(PluginContainer::getName).orElse("unknown")))));
            }
            return CommandResult.success();
        }).build();
    }

    private static CommandSpec createSpongeTPSCommand() {
        return CommandSpec.builder().permission("sponge.command.tps").description(Text.of("Provides TPS (ticks per second) data for loaded worlds.")).arguments(GenericArguments.optional(GenericArguments.world(Text.of("world")))).executor((src, args) -> {
            if (args.hasAny("world")) {
                for (WorldProperties properties : args.getAll("world")) {
                    Optional<World> optWorld = Sponge.getServer().getWorld(properties.getWorldName());
                    if (!optWorld.isPresent()) {
                        src.sendMessage(Text.of(properties.getWorldName() + " has no TPS as it is offline!"));
                        continue;
                    }
                    SpongeCommandFactory.printWorldTickTime(src, optWorld.get());
                }
            } else {
                Sponge.getServer().getWorlds().forEach(world -> SpongeCommandFactory.printWorldTickTime(src, world));
            }
            double serverMeanTickTime = (double)SpongeCommandFactory.mean(SpongeImpl.getServer().field_71311_j).longValue() * 1.0E-6;
            src.sendMessage(Text.of("Overall TPS: ", TextColors.LIGHT_PURPLE, THREE_DECIMAL_DIGITS_FORMATTER.format(Math.min(1000.0 / serverMeanTickTime, 20.0)), TextColors.RESET, ", Mean: ", TextColors.RED, THREE_DECIMAL_DIGITS_FORMATTER.format(serverMeanTickTime), "ms"));
            return CommandResult.success();
        }).build();
    }

    private static void printWorldTickTime(CommandSource src, World world) {
        long[] worldTickTimes = ((MinecraftServerBridge)((Object)SpongeImpl.getServer())).bridge$getWorldTickTimes(((WorldServerBridge)((Object)world)).bridge$getDimensionId());
        double worldMeanTickTime = (double)SpongeCommandFactory.mean(worldTickTimes).longValue() * 1.0E-6;
        double worldTps = Math.min(1000.0 / worldMeanTickTime, 20.0);
        src.sendMessage(Text.of("World [", TextColors.DARK_GREEN, world.getName(), TextColors.RESET, "] (", ((WorldServerBridge)((Object)world)).bridge$getDimensionId(), ") TPS: ", TextColors.LIGHT_PURPLE, THREE_DECIMAL_DIGITS_FORMATTER.format(worldTps), TextColors.RESET, ", Mean: ", TextColors.RED, THREE_DECIMAL_DIGITS_FORMATTER.format(worldMeanTickTime), "ms"));
    }

    private static Long mean(long[] values) {
        Long mean = 0L;
        if (values.length > 0) {
            for (long value : values) {
                mean = mean + value;
            }
            mean = mean / (long)values.length;
        }
        return mean;
    }

    public static CommandSpec createHelpCommand() {
        return CommandSpec.builder().permission("sponge.command.help").arguments(GenericArguments.optional(GenericArguments.firstParsing(GenericArguments.integer(PAGE_KEY), HELP_COMMAND_ARGUMENT, GenericArguments.string(NOT_FOUND)))).description(Text.of("View a list of all commands.")).extendedDescription(Text.of("View a list of all commands. Hover over\n a command to view its description. Click\n a command to insert it into your chat bar.")).executor((src, args) -> {
            if (args.getOne(NOT_FOUND).isPresent()) {
                throw new CommandException(Text.of("No such command: ", args.getOne(NOT_FOUND).get()));
            }
            Optional command = args.getOne(COMMAND_KEY);
            Optional<Integer> page = args.getOne(PAGE_KEY);
            if (command.isPresent()) {
                CommandCallable callable = ((CommandMapping)command.get()).getCallable();
                Optional<Text> desc = callable.getHelp(src);
                if (desc.isPresent()) {
                    src.sendMessage(desc.get());
                } else {
                    src.sendMessage(Text.of("Usage: /", command.get(), callable.getUsage(src)));
                }
                return CommandResult.success();
            }
            ImmutableCollection contents = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Text.of(Sponge.getRegistry().getTranslationById("commands.help.footer").get(), new Object[0]))).addAll((Iterable)SpongeCommandFactory.commands(src).stream().map(input -> SpongeCommandFactory.createDescription(src, input)).collect(Collectors.toList()))).build();
            PaginationList.builder().title(Text.of(TextColors.DARK_GREEN, "Showing Help (/page <page>):")).padding(Text.of(TextColors.DARK_GREEN, "=")).contents(contents).build().sendTo(src, (int)page.orElse(1));
            return CommandResult.success();
        }).build();
    }

    private static CommandCallable createSpongeMetricsCommand() {
        return CommandSpec.builder().arguments(GenericArguments.optionalWeak(GenericArguments.onlyOne(GenericArguments.plugin(PLUGIN_KEY))), GenericArguments.optional(GenericArguments.onlyOne(GenericArguments.choicesInsensitive(COLLECTION_STATE_KEY, COLLECTION_STATE_CHOICES)))).description(Text.of("Gets or sets the metrics collection state")).permission("sponge.command.metrics").executor((source, context) -> {
            SpongeConfig<GlobalConfig> config = SpongeImpl.getGlobalConfigAdapter();
            MetricsCategory category = config.getConfig().getMetricsCategory();
            if (!context.hasAny(PLUGIN_KEY) && !context.hasAny(COLLECTION_STATE_KEY)) {
                Optional<Integer> page = context.getOne(PAGE_KEY);
                ArrayList<Text> contents = new ArrayList<Text>();
                contents.add(SpongeCommandFactory.getMetricsText(TextColors.YELLOW, null, category.getGlobalCollectionState()));
                for (PluginContainer container : Sponge.getPluginManager().getPlugins()) {
                    contents.add(SpongeCommandFactory.getMetricsText(TextColors.LIGHT_PURPLE, container, category.getCollectionState(container)));
                }
                if (source instanceof Player) {
                    PaginationList.builder().title(Text.of("Sponge Metrics")).header(Text.of(TextColors.RED, TextStyles.BOLD, "Warning: ", TextColors.RESET, TextStyles.RESET, "Collection states may not always be respected by plugins.", Text.NEW_LINE)).contents(contents).padding(Text.of("-")).linesPerPage(18).build().sendTo(source, (int)page.orElse(1));
                } else {
                    source.sendMessage(Text.joinWith((Text)Text.NEW_LINE, contents));
                }
                return CommandResult.success();
            }
            Optional optContainer = context.getOne(PLUGIN_KEY);
            Tristate state = (Tristate)((Object)((Object)context.requireOne(COLLECTION_STATE_KEY)));
            if (optContainer.isPresent()) {
                SpongeCommandFactory.setMetricsPluginPermission(category, (PluginContainer)optContainer.get(), state).handle((node, exception) -> {
                    if (exception == null) {
                        SpongeCommandFactory.createMessageTask(source, Text.of("Set collection state for ", ((PluginContainer)optContainer.get()).getName(), " to ", SpongeCommandFactory.getStateText(optContainer.orElse(null), state)));
                    } else {
                        SpongeCommandFactory.createMessageTask(source, FAILED_TEXT);
                    }
                    return node;
                });
                return CommandResult.success();
            }
            SpongeCommandFactory.setMetricsGlobalPermission(category, state).handle((node, exception) -> {
                if (exception == null) {
                    SpongeCommandFactory.createMessageTask(source, Text.of("Set global collection state to ", SpongeCommandFactory.getStateText(optContainer.orElse(null), state)));
                } else {
                    SpongeCommandFactory.createMessageTask(source, FAILED_TEXT);
                }
                return node;
            });
            return CommandResult.success();
        }).build();
    }

    private static Text getStateText(@Nullable PluginContainer container, Tristate state) {
        switch (state) {
            case TRUE: {
                return Text.of(TextColors.GREEN, "Enabled").toBuilder().onHover(TextActions.showText(Text.of("Metrics collection is enabled."))).build();
            }
            case FALSE: {
                return Text.of(TextColors.RED, "Disabled").toBuilder().onHover(TextActions.showText(Text.of("Metrics collection is disabled."))).build();
            }
        }
        return Text.of(TextColors.GRAY, "Undefined").toBuilder().onHover(TextActions.showText(Text.of(container == null ? "Metrics collection has not been defined and will be treated as disabled" : "Metrics collection follows the global state"))).build();
    }

    private static Text getMetricsText(TextColor nameColor, @Nullable PluginContainer container, Tristate state) {
        Text collectionText = SpongeCommandFactory.getStateText(container, state);
        return Text.builder().append(Text.of(" * ", nameColor, container == null ? "Global" : container.getName(), TextColors.RESET, Text.NEW_LINE)).append(Text.of("     Collection: ")).append(collectionText).build();
    }

    private static CompletableFuture<CommentedConfigurationNode> setMetricsGlobalPermission(MetricsCategory category, Tristate state) {
        return SpongeImpl.getGlobalConfigAdapter().updateSetting("metrics.global-state", state, new TypeToken<Tristate>(){});
    }

    private static CompletableFuture<CommentedConfigurationNode> setMetricsPluginPermission(MetricsCategory category, PluginContainer container, Tristate state) {
        HashMap<String, Tristate> pluginStates = new HashMap<String, Tristate>(category.getCollectionStates());
        if (state == Tristate.UNDEFINED) {
            pluginStates.remove(container.getId());
        } else {
            pluginStates.put(container.getId(), state);
        }
        return SpongeHooks.savePluginsInMetricsConfig(pluginStates);
    }

    private static void createMessageTask(CommandSource source, Text message) {
        Task.builder().execute(() -> source.sendMessage(message)).submit(SpongeImpl.getPlugin());
    }

    private static Collection<String> commandsStr(CommandSource src) {
        return SpongeCommandFactory.commands(src).stream().map(CommandMapping::getPrimaryAlias).collect(Collectors.toList());
    }

    private static TreeSet<CommandMapping> commands(CommandSource src) {
        TreeSet<CommandMapping> commands = new TreeSet<CommandMapping>(COMMAND_COMPARATOR);
        commands.addAll(SpongeImpl.getCommandManager().getAll().values().stream().filter(input -> SpongeCommandDispatcher.ON_DISCOVERY.test(src, (CommandMapping)input)).collect(Collectors.toList()));
        return commands;
    }

    private static Text createDescription(CommandSource source, CommandMapping mapping) {
        Optional<Text> description = mapping.getCallable().getShortDescription(source);
        LiteralText.Builder text = Text.builder("/" + mapping.getPrimaryAlias());
        ((Text.Builder)text).color(TextColors.GREEN);
        ((Text.Builder)text).onClick(TextActions.suggestCommand("/" + mapping.getPrimaryAlias() + " "));
        Optional<Text> longDescription = mapping.getCallable().getHelp(source);
        if (longDescription.isPresent()) {
            ((Text.Builder)text).onHover(TextActions.showText(longDescription.get()));
        }
        return Text.of(text, " ", description.orElse(mapping.getCallable().getUsage(source)));
    }

    private static abstract class ConfigIncludingTrackerUsingExecutor
    extends ConfigUsingExecutor {
        ConfigIncludingTrackerUsingExecutor(boolean requireWorldLoaded) {
            super(requireWorldLoaded);
        }

        @Override
        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            int successes = 0;
            if (args.hasAny("tracker")) {
                src.sendMessage(Text.of("Tracker: ", this.processTracker(SpongeImpl.getTrackerConfigAdapter(), src, args)));
                ++successes;
            }
            return this.execute(src, args, successes);
        }

        protected Text processTracker(SpongeConfig<TrackerConfig> config, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }
    }

    private static abstract class ConfigUsingExecutor
    implements CommandExecutor {
        private boolean requireWorldLoaded;

        ConfigUsingExecutor(boolean requireWorldLoaded) {
            this.requireWorldLoaded = requireWorldLoaded;
        }

        @Override
        public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
            return this.execute(src, args, 0);
        }

        public CommandResult execute(CommandSource src, CommandContext args, int successes) throws CommandException {
            if (args.hasAny("global")) {
                src.sendMessage(Text.of("Global: ", this.processGlobal(SpongeImpl.getGlobalConfigAdapter(), src, args)));
                ++successes;
            }
            if (args.hasAny("dimension")) {
                for (DimensionType dimensionType : args.getAll("dimension")) {
                    src.sendMessage(Text.of("Dimension ", dimensionType.getName(), ": ", this.processDimension(((DimensionTypeBridge)((Object)dimensionType)).bridge$getDimensionConfig(), dimensionType, src, args)));
                    ++successes;
                }
            }
            if (args.hasAny("world")) {
                for (WorldProperties properties : args.getAll("world")) {
                    Optional<World> world = SpongeImpl.getGame().getServer().getWorld(properties.getUniqueId());
                    if (!world.isPresent() && this.requireWorldLoaded) {
                        throw new CommandException(Text.of("World ", properties.getWorldName(), " is not loaded, cannot work with it"));
                    }
                    src.sendMessage(Text.of("World ", properties.getWorldName(), ": ", this.processWorld(((WorldInfoBridge)((Object)properties)).bridge$getConfigAdapter(), world.orElse(null), src, args)));
                    ++successes;
                }
            }
            if (successes == 0) {
                throw new CommandException(Text.of("At least one target flag must be specified"));
            }
            return CommandResult.builder().successCount(successes).build();
        }

        protected Text processGlobal(SpongeConfig<GlobalConfig> config, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }

        protected Text processDimension(SpongeConfig<DimensionConfig> config, DimensionType dim, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }

        protected Text processWorld(SpongeConfig<WorldConfig> config, World world, CommandSource source, CommandContext args) throws CommandException {
            return this.process(config, source, args);
        }

        protected Text process(SpongeConfig<? extends ConfigBase> config, CommandSource source, CommandContext args) throws CommandException {
            return Text.of("Unimplemented");
        }
    }
}

