/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config.category;

import com.google.common.collect.Lists;
import java.util.List;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.common.config.category.ConfigCategory;

@ConfigSerializable
public class TimingsCategory
extends ConfigCategory {
    @Setting(comment="Enables the verbose mode for the timings module.")
    private boolean verbose = false;
    @Setting(comment="Enables the timing module")
    private boolean enabled = true;
    @Setting(value="server-name-privacy", comment="Hides the server name in the Aikar webviewer to no leak the l33t server you are running")
    private boolean serverNamePrivacy = false;
    @Setting(value="hidden-config-entries", comment="These configuration entries/paths/sections are removed before the report is sent.\nThis is to prevent credentials from being leaked unintentionally.\nNote: The 'sponge.sql' section is always ignored\nand thus is never sent to the webviewer regardless of this config.")
    private List<String> hiddenConfigEntries = Lists.newArrayList("sponge.sql");
    @Setting(value="history-interval", comment="Modulo value how often a tick should be pushed to the timings history")
    private int historyInterval = 300;
    @Setting(value="history-length", comment="How long the list of said history can get")
    private int historyLength = 3600;

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isServerNamePrivate() {
        return this.serverNamePrivacy;
    }

    public List<String> getHiddenConfigEntries() {
        return this.hiddenConfigEntries;
    }

    public int getHistoryInterval() {
        return this.historyInterval;
    }

    public void setHistoryInterval(int historyInterval) {
        this.historyInterval = historyInterval;
    }

    public int getHistoryLength() {
        return this.historyLength;
    }

    public void setHistoryLength(int historyLength) {
        this.historyLength = historyLength;
    }
}

