/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.Archetype;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.LocatableSnapshot;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.nbt.NbtDataType;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataUtil;

public abstract class AbstractArchetype<C extends CatalogType, S extends LocatableSnapshot<S>, E>
implements Archetype<S, E> {
    protected final C type;
    protected NBTTagCompound data;

    protected AbstractArchetype(C type, NBTTagCompound data) {
        this.type = type;
        this.data = data;
    }

    protected abstract NbtDataType getDataType();

    protected abstract ValidationType getValidationType();

    @Override
    public boolean validateRawData(DataView container) {
        return DataUtil.getValidators(this.getValidationType()).validate(container);
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
        Preconditions.checkNotNull(container, "Raw data cannot be null!");
        NBTTagCompound copy = NbtTranslator.getInstance().translateData(container);
        DataUtil.getValidators(this.getValidationType()).validate(copy);
        this.data = copy;
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return SpongeImpl.getPropertyRegistry().getStore(propertyClass).flatMap(store -> store.getFor(this));
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return SpongeImpl.getPropertyRegistry().getPropertiesFor(this);
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        return DataUtil.getRawNbtProcessor(this.getDataType(), containerClass).flatMap(processor -> processor.readFrom(this.data));
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        return DataUtil.getRawNbtProcessor(this.getDataType(), containerClass).flatMap(processor -> processor.readFrom(this.data));
    }

    @Override
    public boolean supports(Class<? extends DataManipulator<?, ?>> holderClass) {
        return DataUtil.getRawNbtProcessor(this.getDataType(), holderClass).map(processor -> processor.isCompatible(this.data)).orElse(true);
    }

    @Override
    public <R> DataTransactionResult offer(Key<? extends BaseValue<R>> key, R value) {
        return DataUtil.getNbtProcessor(this.getDataType(), key).map(processor -> processor.offer(this.data, value)).orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult offer(DataManipulator<?, ?> valueContainer, MergeFunction function) {
        return DataUtil.getRawNbtProcessor(this.getDataType(), valueContainer.getClass()).map(processor -> {
            Optional optionalManipulator = processor.readFrom(this.data);
            DataManipulator newManipulator = optionalManipulator.map(manipulator -> function.merge(manipulator, valueContainer)).orElse(valueContainer);
            Optional<NBTTagCompound> optional = processor.storeToCompound(this.data, newManipulator);
            if (optional.isPresent()) {
                this.data = optional.get();
            }
            return DataTransactionResult.failNoData();
        }).orElseGet(() -> DataUtil.apply(this.data, valueContainer));
    }

    @Override
    public DataTransactionResult remove(Class<? extends DataManipulator<?, ?>> containerClass) {
        return DataUtil.getRawNbtProcessor(this.getDataType(), containerClass).map(processor -> processor.remove(this.data)).orElseGet(() -> DataUtil.remove(this.data, containerClass));
    }

    @Override
    public DataTransactionResult remove(Key<?> key) {
        return DataUtil.getRawNbtProcessor(this.getDataType(), key).map(processor -> processor.remove(this.data)).orElseGet(DataTransactionResult::failNoData);
    }

    @Override
    public DataTransactionResult undo(DataTransactionResult result) {
        if (result.getReplacedData().isEmpty() && result.getSuccessfulData().isEmpty()) {
            return DataTransactionResult.successNoData();
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        for (ImmutableValue<?> replaced : result.getReplacedData()) {
            builder.absorbResult(this.offer(replaced));
        }
        for (ImmutableValue<?> successful : result.getSuccessfulData()) {
            builder.absorbResult(this.remove(successful));
        }
        return builder.build();
    }

    @Override
    public DataTransactionResult copyFrom(DataHolder that, MergeFunction function) {
        return DataTransactionResult.failNoData();
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        return DataUtil.getNbtProcessors(this.getDataType()).stream().map(processor -> processor.readFrom(this.data)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public <R> Optional<R> get(Key<? extends BaseValue<R>> key) {
        return DataUtil.getNbtProcessor(this.getDataType(), key).flatMap(processor -> processor.readValue(this.data));
    }

    @Override
    public <R, V extends BaseValue<R>> Optional<V> getValue(Key<V> key) {
        return DataUtil.getNbtProcessor(this.getDataType(), key).flatMap(processor -> processor.readFrom(this.data));
    }

    @Override
    public boolean supports(Key<?> key) {
        return DataUtil.getRawNbtProcessor(this.getDataType(), key).map(processor -> processor.isCompatible(this.getDataType())).orElse(true);
    }

    @Override
    public Set<Key<?>> getKeys() {
        return DataUtil.getNbtValueProcessors(this.getDataType()).stream().map(processor -> processor.readFrom(this.data)).filter(Optional::isPresent).map(Optional::get).map(BaseValue::getKey).collect(Collectors.toSet());
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        return DataUtil.getNbtValueProcessors(this.getDataType()).stream().map(processor -> processor.readFrom(this.data)).filter(Optional::isPresent).map(Optional::get).filter(value -> value instanceof Value).map(value -> (Value)value).map(Value::asImmutable).collect(Collectors.toSet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractArchetype)) {
            return false;
        }
        AbstractArchetype that = (AbstractArchetype)o;
        return this.type.equals(that.type) && this.data.equals((Object)that.data);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", this.type).add("data", this.data).toString();
    }

    public NBTTagCompound getCompound() {
        return this.data;
    }
}

