/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializerCollection;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.ImmutableDataBuilder;
import org.spongepowered.api.data.ImmutableDataHolder;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.DataSerializableTypeSerializer;
import org.spongepowered.common.data.DataUpdaterDelegate;
import org.spongepowered.common.data.MemoryDataContainer;
import org.spongepowered.common.data.SpongeDataRegistration;
import org.spongepowered.common.data.SpongeDataRegistrationBuilder;
import org.spongepowered.common.data.SpongeManipulatorRegistry;
import org.spongepowered.common.data.builder.manipulator.SpongeDataManipulatorBuilder;
import org.spongepowered.common.data.builder.manipulator.SpongeImmutableDataManipulatorBuilder;
import org.spongepowered.common.registry.type.data.DataTranslatorRegistryModule;
import org.spongepowered.common.registry.type.data.KeyRegistryModule;
import org.spongepowered.common.util.Constants;

@Singleton
public final class SpongeDataManager
implements DataManager {
    private final Map<Class<?>, DataBuilder<?>> builders = new IdentityHashMap();
    final Map<Class<? extends DataManipulator<?, ?>>, DataManipulatorBuilder<?, ?>> builderMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends ImmutableDataManipulator<?, ?>>, DataManipulatorBuilder<?, ?>> immutableBuilderMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends ImmutableDataHolder<?>>, ImmutableDataBuilder<?, ?>> immutableDataBuilderMap = new MapMaker().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends DataSerializable>, List<DataContentUpdater>> updatersMap = new IdentityHashMap<Class<? extends DataSerializable>, List<DataContentUpdater>>();
    static boolean allowRegistrations;

    public static SpongeDataManager getInstance() {
        return SpongeImpl.getDataManager();
    }

    @Inject
    private SpongeDataManager() {
    }

    @Override
    public <T extends DataSerializable> void registerBuilder(Class<T> clazz, DataBuilder<T> builder) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(builder);
        if (!this.builders.containsKey(clazz)) {
            if (!(builder instanceof AbstractDataBuilder || builder instanceof SpongeDataManipulatorBuilder || builder instanceof SpongeImmutableDataManipulatorBuilder)) {
                SpongeImpl.getLogger().warn("A custom DataBuilder is not extending AbstractDataBuilder! It is recommended that the custom data builder does extend it to gain automated content versioning updates and maintain simplicity. The offending builder's class is: {}", (Object)builder.getClass());
            }
            this.builders.put(clazz, builder);
        } else {
            SpongeImpl.getLogger().warn("A DataBuilder has already been registered for {}. Attempted to register {} instead.", (Object)clazz, (Object)builder.getClass());
        }
    }

    @Override
    public <T extends DataSerializable> void registerContentUpdater(Class<T> clazz, DataContentUpdater updater) {
        Preconditions.checkNotNull(updater, "DataContentUpdater was null!");
        if (!this.updatersMap.containsKey(Preconditions.checkNotNull(clazz, "DataSerializable class was null!"))) {
            this.updatersMap.put(clazz, new ArrayList());
        }
        List<DataContentUpdater> updaters = this.updatersMap.get(clazz);
        updaters.add(updater);
        Collections.sort(updaters, Constants.Functional.DATA_CONTENT_UPDATER_COMPARATOR);
    }

    @Override
    public <T extends DataSerializable> Optional<DataContentUpdater> getWrappedContentUpdater(Class<T> clazz, int fromVersion, int toVersion) {
        Preconditions.checkArgument(fromVersion != toVersion, "Attempting to convert to the same version!");
        Preconditions.checkArgument(fromVersion < toVersion, "Attempting to backwards convert data! This isn't supported!");
        List<DataContentUpdater> updaters = this.updatersMap.get(Preconditions.checkNotNull(clazz, "DataSerializable class was null!"));
        if (updaters == null) {
            return Optional.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int version = fromVersion;
        for (DataContentUpdater updater : updaters) {
            if (updater.getInputVersion() != version || updater.getOutputVersion() > toVersion) continue;
            version = updater.getOutputVersion();
            builder.add(updater);
        }
        if (version < toVersion || version > toVersion) {
            IllegalStateException e = new IllegalStateException("The requested content version for: " + clazz.getSimpleName() + " was requested, \nhowever, the versions supplied: from " + fromVersion + " to " + toVersion + " is impossible\nas the latest version registered is: " + version + ". Please notify the developer of\nthe requested consumed DataSerializable of this error.");
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.of(new DataUpdaterDelegate((ImmutableList<DataContentUpdater>)builder.build(), fromVersion, toVersion));
    }

    <T extends DataSerializable> void registerBuilderAndImpl(Class<T> clazz, Class<? extends T> implClass, DataBuilder<T> builder) {
        this.registerBuilder(clazz, builder);
        this.registerBuilder(implClass, builder);
    }

    @Override
    public <T extends DataSerializable> Optional<DataBuilder<T>> getBuilder(Class<T> clazz) {
        Preconditions.checkNotNull(clazz);
        if (this.builders.containsKey(clazz)) {
            return Optional.of(this.builders.get(clazz));
        }
        if (this.builderMap.containsKey(clazz)) {
            return Optional.of((DataBuilder)this.builderMap.get(clazz));
        }
        if (this.immutableDataBuilderMap.containsKey(clazz)) {
            return Optional.of((DataBuilder)this.immutableDataBuilderMap.get(clazz));
        }
        return Optional.empty();
    }

    @Override
    public <T extends DataSerializable> Optional<T> deserialize(Class<T> clazz, DataView dataView) {
        Optional<DataBuilder<DataBuilder>> optional = this.getBuilder(clazz);
        return optional.flatMap(tDataBuilder -> tDataBuilder.build(dataView));
    }

    @Override
    public <T extends ImmutableDataHolder<T>, B extends ImmutableDataBuilder<T, B>> void register(Class<T> holderClass, B builder) {
        if (this.immutableDataBuilderMap.containsKey(Preconditions.checkNotNull(holderClass))) {
            throw new IllegalStateException("Already registered the DataUtil for " + holderClass.getCanonicalName());
        }
        this.immutableDataBuilderMap.put(holderClass, Preconditions.checkNotNull(builder));
    }

    @Override
    public <T extends ImmutableDataHolder<T>, B extends ImmutableDataBuilder<T, B>> Optional<B> getImmutableBuilder(Class<T> holderClass) {
        return Optional.ofNullable(this.immutableDataBuilderMap.get(Preconditions.checkNotNull(holderClass)));
    }

    public static void finalizeRegistration() {
        allowRegistrations = false;
        SpongeManipulatorRegistry.getInstance().bake();
        KeyRegistryModule.getInstance().registerKeyListeners();
    }

    @Override
    public void registerLegacyManipulatorIds(String legacyId, DataRegistration<?, ?> registration) {
        Preconditions.checkState(allowRegistrations);
        SpongeManipulatorRegistry.getInstance().registerLegacyId(legacyId, registration);
    }

    @Override
    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataManipulatorBuilder<T, I>> getManipulatorBuilder(Class<T> manipulatorClass) {
        return Optional.ofNullable(this.builderMap.get(Preconditions.checkNotNull(manipulatorClass)));
    }

    @Override
    public <T extends DataManipulator<T, I>, I extends ImmutableDataManipulator<I, T>> Optional<DataManipulatorBuilder<T, I>> getImmutableManipulatorBuilder(Class<I> immutableManipulatorClass) {
        return Optional.ofNullable(this.immutableBuilderMap.get(Preconditions.checkNotNull(immutableManipulatorClass)));
    }

    @Override
    @Deprecated
    public <T> void registerTranslator(Class<T> objectClass, DataTranslator<T> translator) {
        Preconditions.checkState(allowRegistrations, "Registrations are no longer allowed");
        Preconditions.checkArgument(translator.getToken().isSupertypeOf(objectClass), "DataTranslator is not compatible with the target object class: %s", objectClass);
        DataTranslatorRegistryModule.getInstance().registerAdditionalCatalog(translator);
    }

    @Override
    public <T> Optional<DataTranslator<T>> getTranslator(Class<T> objectClass) {
        return DataTranslatorRegistryModule.getInstance().getByClass(objectClass);
    }

    @Override
    public Collection<Class<? extends DataManipulator<?, ?>>> getAllRegistrationsFor(PluginContainer container) {
        return SpongeManipulatorRegistry.getInstance().getRegistrations(container);
    }

    @Override
    public DataContainer createContainer() {
        return new MemoryDataContainer();
    }

    @Override
    public DataContainer createContainer(DataView.SafetyMode safety) {
        return new MemoryDataContainer(safety);
    }

    public Optional<DataManipulatorBuilder<?, ?>> getWildManipulatorBuilder(Class<? extends DataManipulator<?, ?>> manipulatorClass) {
        return Optional.ofNullable(this.builderMap.get(Preconditions.checkNotNull(manipulatorClass)));
    }

    public Optional<DataManipulatorBuilder<?, ?>> getWildBuilderForImmutable(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return Optional.ofNullable(this.immutableBuilderMap.get(Preconditions.checkNotNull(immutable)));
    }

    <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> void validateRegistration(SpongeDataRegistrationBuilder<M, I> builder) {
        Preconditions.checkState(allowRegistrations);
        Class manipulatorClass = builder.manipulatorClass;
        Class implementationClass = builder.implementationData;
        Class immutableClass = builder.immutableClass;
        Class immutableImplementation = builder.immutableImplementation;
        DataManipulatorBuilder manipulatorBuilder = builder.manipulatorBuilder;
        Preconditions.checkState(!this.builders.containsKey(manipulatorClass), "DataManipulator already registered!");
        Preconditions.checkState(!this.builderMap.containsKey(manipulatorClass), "DataManipulator already registered!");
        Preconditions.checkState(!this.builderMap.containsValue(manipulatorBuilder), "DataManipulatorBuilder already registered!");
        Preconditions.checkState(!this.builders.containsKey(immutableClass), "ImmutableDataManipulator already registered!");
        Preconditions.checkState(!this.immutableBuilderMap.containsKey(immutableClass), "ImmutableDataManipulator already registered!");
        Preconditions.checkState(!this.immutableBuilderMap.containsValue(manipulatorBuilder), "DataManipulatorBuilder already registered!");
        if (implementationClass != null) {
            Preconditions.checkState(!this.builders.containsKey(implementationClass), "DataManipulator implementation already registered!");
            Preconditions.checkState(!this.builderMap.containsKey(implementationClass), "DataManipulator implementation already registered!");
        }
        if (immutableImplementation != null) {
            Preconditions.checkState(!this.builders.containsKey(immutableImplementation), "ImmutableDataManipulator implementation already registered!");
            Preconditions.checkState(!this.immutableBuilderMap.containsKey(immutableImplementation), "ImmutableDataManipulator implementation already registered!");
        }
    }

    public static boolean areRegistrationsComplete() {
        return !allowRegistrations;
    }

    <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> void registerInternally(SpongeDataRegistration<M, I> registration) {
        this.builders.put(registration.getManipulatorClass(), registration.getDataManipulatorBuilder());
        this.builderMap.put(registration.getManipulatorClass(), registration.getDataManipulatorBuilder());
        if (!registration.getImplementationClass().equals(registration.getManipulatorClass())) {
            this.builders.put(registration.getImplementationClass(), registration.getDataManipulatorBuilder());
            this.builderMap.put(registration.getImplementationClass(), registration.getDataManipulatorBuilder());
        }
        this.immutableBuilderMap.put(registration.getImmutableManipulatorClass(), registration.getDataManipulatorBuilder());
        if (!registration.getImmutableImplementationClass().equals(registration.getImmutableManipulatorClass())) {
            this.immutableBuilderMap.put(registration.getImmutableImplementationClass(), registration.getDataManipulatorBuilder());
        }
    }

    static {
        TypeSerializerCollection.defaults().register(DataSerializableTypeSerializer.predicate(), DataSerializableTypeSerializer.INSTANCE);
        allowRegistrations = true;
    }
}

