/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.SpongeKey;
import org.spongepowered.common.util.SpongeCatalogBuilder;

public final class SpongeKeyBuilder<E, V extends BaseValue<E>>
extends SpongeCatalogBuilder<Key<V>, Key.Builder<E, V>>
implements Key.Builder<E, V> {
    private static final Set<String> loggedPlugins = new HashSet<String>();
    @Nullable
    TypeToken<V> valueToken;
    @Nullable
    Translation name;
    @Nullable
    DataQuery query;

    @Override
    public <T, B extends BaseValue<T>> Key.Builder<T, B> type(TypeToken<B> token) {
        this.valueToken = Preconditions.checkNotNull(token, "Value Token cannot be null!");
        return this;
    }

    @Override
    public Key.Builder<E, V> query(DataQuery query) {
        Preconditions.checkArgument(!query.getParts().isEmpty(), "DataQuery cannot be null!");
        this.query = query;
        return this;
    }

    @Override
    public Key.Builder<E, V> id(String id) {
        int index = id.indexOf(58);
        if (index != -1) {
            String pluginId = id.substring(0, index);
            if (loggedPlugins.add(pluginId)) {
                SpongeImpl.getLogger().warn(pluginId + ": It is no longer required to include the plugin id when specifying a Key id through Key.Builder#id. This is deprecated and may be removed later. The plugin id will be retrieved from the current PluginContainer in the cause stack. Key: " + id);
            }
            id = id.substring(index + 1);
        }
        return (Key.Builder)super.id(id);
    }

    @Override
    protected Key<V> build(PluginContainer plugin, String id, Translation name) {
        Preconditions.checkState(this.valueToken != null, "Value token must be set!");
        Preconditions.checkState(this.query != null, "DataQuery must be set!");
        return new SpongeKey<V>(plugin.getId() + ':' + id, name, this.valueToken, this.query, plugin);
    }

    @Override
    public Key.Builder<E, V> reset() {
        super.reset();
        this.valueToken = null;
        this.id = null;
        this.name = null;
        this.query = null;
        return this;
    }
}

