/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimap;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.DataRegistrationNotFoundException;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.registry.util.RegistrationDependency;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.CustomDataRegistrationCategory;
import org.spongepowered.common.config.type.CustomDataConfig;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.SpongeDataRegistration;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.data.builder.manipulator.SpongeDataManipulatorBuilder;
import org.spongepowered.common.data.nbt.NbtDataType;
import org.spongepowered.common.data.nbt.SpongeNbtProcessorDelegate;
import org.spongepowered.common.data.nbt.data.NbtDataProcessor;
import org.spongepowered.common.data.nbt.value.NbtValueProcessor;
import org.spongepowered.common.data.util.DataFunction;
import org.spongepowered.common.data.util.DataProcessorDelegate;
import org.spongepowered.common.data.util.ValueProcessorDelegate;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;
import org.spongepowered.common.registry.type.data.KeyRegistryModule;
import org.spongepowered.common.util.Constants;

@RegistrationDependency(value={KeyRegistryModule.class})
public class SpongeManipulatorRegistry
implements SpongeAdditionalCatalogRegistryModule<DataRegistration<?, ?>> {
    private static final SpongeManipulatorRegistry INSTANCE = new SpongeManipulatorRegistry();
    private final Map<Class<? extends DataManipulator<?, ?>>, Class<? extends DataManipulator<?, ?>>> interfaceToImplDataManipulatorClasses = new IdentityHashMap();
    private final Map<Class<? extends DataManipulator<?, ?>>, DataProcessorDelegate<?, ?>> dataProcessorDelegates = new IdentityHashMap();
    private final Map<Class<? extends ImmutableDataManipulator<?, ?>>, DataProcessorDelegate<?, ?>> immutableDataProcessorDelegates = new IdentityHashMap();
    private ImmutableTable<Class<? extends DataManipulator<?, ?>>, NbtDataType, NbtDataProcessor<?, ?>> nbtProcessorTable = ImmutableTable.of();
    private ImmutableTable<Key<?>, NbtDataType, NbtValueProcessor<?, ?>> nbtValueTable = ImmutableTable.of();
    private final Map<Key<? extends BaseValue<?>>, ValueProcessorDelegate<?, ?>> valueDelegates = new IdentityHashMap();
    private Multimap<PluginContainer, DataRegistration<?, ?>> pluginBasedRegistrations = ImmutableMultimap.of();
    private Collection<DataRegistration<?, ?>> registrations = Collections.emptyList();
    private Map<Class<? extends DataManipulator<?, ?>>, DataRegistration<?, ?>> manipulatorRegistrationMap = ImmutableMap.of();
    private Map<Class<? extends ImmutableDataManipulator<?, ?>>, DataRegistration<?, ?>> immutableRegistrationMap = ImmutableMap.of();
    private Map<String, DataRegistration<?, ?>> registrationMap = ImmutableMap.of();
    private final Map<String, DataRegistration<?, ?>> legacyRegistrationIds = new MapMaker().concurrencyLevel(4).makeMap();
    @Nullable
    private TemporaryRegistry tempRegistry = new TemporaryRegistry();

    public static SpongeManipulatorRegistry getInstance() {
        return INSTANCE;
    }

    void registerLegacyId(String legacyId, DataRegistration<?, ?> registration) {
        if (this.legacyRegistrationIds.containsKey(legacyId)) {
            throw new IllegalStateException("Legacy registration id already registered: id" + legacyId + " for registration: " + registration);
        }
        this.legacyRegistrationIds.put(legacyId, registration);
    }

    @Override
    public boolean allowsApiRegistration() {
        return true;
    }

    @Override
    public void registerAdditionalCatalog(DataRegistration<?, ?> extraCatalog) {
        Preconditions.checkArgument(extraCatalog instanceof SpongeDataRegistration);
        SpongeDataRegistration registration = (SpongeDataRegistration)extraCatalog;
        SpongeDataManager.getInstance().registerInternally(registration);
        SpongeManipulatorRegistry.getInstance().register(registration);
    }

    @Override
    public Optional<DataRegistration<?, ?>> getById(String id) {
        DataRegistration<?, ?> dataRegistration = this.registrationMap.get(id);
        return Optional.ofNullable(dataRegistration);
    }

    @Override
    public Collection<DataRegistration<?, ?>> getAll() {
        return this.registrationMap.values();
    }

    private SpongeManipulatorRegistry() {
    }

    public <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> DataRegistration<M, I> getRegistrationFor(Class<? extends M> manipulator) {
        DataRegistration<?, ?> dataRegistration = this.manipulatorRegistrationMap.get(manipulator.getClass());
        if (dataRegistration == null) {
            throw new DataRegistrationNotFoundException("Could not locate a DataRegistration for class", manipulator);
        }
        return dataRegistration;
    }

    public DataRegistration<?, ?> getRegistrationFor(DataManipulator<?, ?> manipulator) {
        DataRegistration<?, ?> dataRegistration = this.manipulatorRegistrationMap.get(manipulator.getClass());
        if (dataRegistration == null) {
            if (this.tempRegistry != null) {
                for (SpongeDataRegistration registration : this.tempRegistry.registrations) {
                    if (registration.getManipulatorClass() != manipulator.getClass()) continue;
                    return registration;
                }
            }
            throw new DataRegistrationNotFoundException("Could not locate a DataRegistration for class " + manipulator.getClass());
        }
        return dataRegistration;
    }

    public DataRegistration<?, ?> getRegistrationFor(ImmutableDataManipulator<?, ?> immutable) {
        DataRegistration<?, ?> dataRegistration = this.immutableRegistrationMap.get(immutable.getClass());
        if (dataRegistration == null) {
            if (this.tempRegistry != null) {
                for (SpongeDataRegistration registration : this.tempRegistry.registrations) {
                    if (registration.getImmutableManipulatorClass() != immutable.getClass()) continue;
                    return registration;
                }
            }
            throw new DataRegistrationNotFoundException("Could not locate a DataRegistration for class " + immutable.getClass());
        }
        return dataRegistration;
    }

    public <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> DataRegistration<M, I> getRegistrationForImmutable(Class<? extends I> manipulator) {
        DataRegistration<?, ?> dataRegistration = this.immutableRegistrationMap.get(manipulator);
        if (dataRegistration == null) {
            throw new DataRegistrationNotFoundException("Could not locate a DataRegistration for class", null, (Class<? extends ImmutableDataManipulator<?, ?>>)manipulator);
        }
        return dataRegistration;
    }

    public <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> Optional<DataRegistration<M, I>> getRegistrationFor(String id) {
        DataRegistration<?, ?> dataRegistration = this.registrationMap.get(id);
        return Optional.ofNullable(dataRegistration);
    }

    <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> void validateRegistrationId(String id) {
        Preconditions.checkState(this.tempRegistry != null);
        this.tempRegistry.registrations.stream().filter(registration -> registration.getId().equalsIgnoreCase(id)).findFirst().ifPresent(registration -> {
            throw new IllegalStateException("Existing DataRegistration exists for id: " + id);
        });
    }

    Collection<Class<? extends DataManipulator<?, ?>>> getRegistrations(PluginContainer container) {
        return this.pluginBasedRegistrations.get(container).stream().map(DataRegistration::getManipulatorClass).collect(Collectors.toList());
    }

    public Optional<DataRegistration<?, ?>> getRegistrationForLegacyId(String id) {
        return Optional.ofNullable(this.legacyRegistrationIds.get(id));
    }

    public <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> DataRegistration<M, I> register(SpongeDataRegistration<M, I> registration) {
        Preconditions.checkState(this.tempRegistry != null);
        if (this.tempRegistry.registrations.contains(registration)) {
            throw new IllegalStateException("Existing DataRegistration exists for id: " + registration);
        }
        this.tempRegistry.registrations.add(registration);
        return registration;
    }

    public <M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>> SpongeManipulatorRegistry register(Class<M> manipulatorClass, Class<? extends M> implClass, Class<I> immutableDataManipulator, Class<? extends I> implImClass, DataProcessor<M, I> processor) {
        Preconditions.checkState(this.tempRegistry != null);
        if (!this.interfaceToImplDataManipulatorClasses.containsKey(manipulatorClass)) {
            this.interfaceToImplDataManipulatorClasses.put(manipulatorClass, implClass);
        }
        Preconditions.checkState(SpongeDataManager.allowRegistrations, "Registrations are no longer allowed!");
        CopyOnWriteArrayList<DataProcessor<M, I>> processorList = (CopyOnWriteArrayList<DataProcessor<M, I>>)this.tempRegistry.processorMap.get(manipulatorClass);
        if (processorList == null) {
            processorList = new CopyOnWriteArrayList<DataProcessor<M, I>>();
            this.tempRegistry.processorMap.put(manipulatorClass, processorList);
            this.tempRegistry.processorMap.put(implClass, processorList);
        }
        Preconditions.checkArgument(!processorList.contains(processor), "Duplicate DataProcessor Registration!");
        processorList.add(processor);
        CopyOnWriteArrayList<DataProcessor<M, I>> immutableProcessorList = (CopyOnWriteArrayList<DataProcessor<M, I>>)this.tempRegistry.immutableProcessorMap.get(immutableDataManipulator);
        if (immutableProcessorList == null) {
            immutableProcessorList = new CopyOnWriteArrayList<DataProcessor<M, I>>();
            this.tempRegistry.immutableProcessorMap.put(immutableDataManipulator, immutableProcessorList);
            this.tempRegistry.immutableProcessorMap.put(implImClass, immutableProcessorList);
        }
        Preconditions.checkArgument(!immutableProcessorList.contains(processor), "Duplicate DataProcessor Registration!");
        immutableProcessorList.add(processor);
        return this;
    }

    public <E, V extends BaseValue<E>> void registerValueProcessor(Key<V> key, ValueProcessor<E, V> valueProcessor) {
        Preconditions.checkState(this.tempRegistry != null);
        Preconditions.checkNotNull(valueProcessor);
        Preconditions.checkArgument(!(valueProcessor instanceof ValueProcessorDelegate), "Cannot register ValueProcessorDelegates! READ THE DOCS!");
        Preconditions.checkNotNull(key);
        List processorList = this.tempRegistry.valueProcessorMap.computeIfAbsent(key, k -> Collections.synchronizedList(Lists.newArrayList()));
        Preconditions.checkArgument(!processorList.contains(valueProcessor), "Duplicate ValueProcessor registration!");
        processorList.add(valueProcessor);
    }

    @Nullable
    public DataProcessor<?, ?> getDelegate(Class<?> mClass) {
        if (this.tempRegistry != null) {
            if (DataManipulator.class.isAssignableFrom(mClass)) {
                List dataProcessors = (List)this.tempRegistry.processorMap.get(mClass);
                if (dataProcessors == null) {
                    return null;
                }
                return new DataProcessorDelegate(ImmutableList.copyOf(dataProcessors));
            }
            List dataProcessors = (List)this.tempRegistry.immutableProcessorMap.get(mClass);
            if (dataProcessors == null) {
                return null;
            }
            return new DataProcessorDelegate(ImmutableList.copyOf(dataProcessors));
        }
        return DataManipulator.class.isAssignableFrom(mClass) ? (DataProcessor)this.dataProcessorDelegates.get(mClass) : (DataProcessor)this.immutableDataProcessorDelegates.get(mClass);
    }

    @Nullable
    public ValueProcessor<?, ?> getDelegate(Key<?> key) {
        if (this.tempRegistry != null) {
            List list = (List)this.tempRegistry.valueProcessorMap.get(key);
            if (list == null) {
                return null;
            }
            return new ValueProcessorDelegate(key, ImmutableList.copyOf(list));
        }
        return this.valueDelegates.get(key);
    }

    @Nullable
    public NbtDataProcessor<?, ?> getNbtDelegate(NbtDataType dataType, Class<?> manipulatorClass) {
        return (NbtDataProcessor)this.nbtProcessorTable.get(dataType, manipulatorClass);
    }

    @Nullable
    public NbtValueProcessor<?, ?> getNbtProcessor(NbtDataType type, Key<?> key) {
        return (NbtValueProcessor)this.nbtValueTable.get(type, key);
    }

    public Collection<NbtDataProcessor<?, ?>> getNbtProcessors(NbtDataType nbtDataType) {
        return ((ImmutableMap)this.nbtProcessorTable.column((Object)nbtDataType)).values();
    }

    public Collection<NbtValueProcessor<?, ?>> getNbtValueProcessors(NbtDataType nbtDataType) {
        return ((ImmutableMap)this.nbtValueTable.column((Object)nbtDataType)).values();
    }

    void bake() {
        Preconditions.checkState(this.tempRegistry != null);
        this.tempRegistry.valueProcessorMap.forEach((key, value) -> {
            ImmutableList.Builder valueListBuilder = ImmutableList.builder();
            value.sort(Constants.Functional.VALUE_PROCESSOR_COMPARATOR);
            valueListBuilder.addAll((Iterable)value);
            ValueProcessorDelegate delegate = new ValueProcessorDelegate(key, valueListBuilder.build());
            this.valueDelegates.put((Key<BaseValue<?>>)key, delegate);
        });
        this.tempRegistry.processorMap.forEach((key, value) -> {
            ImmutableList.Builder dataListBuilder = ImmutableList.builder();
            value.sort(Constants.Functional.DATA_PROCESSOR_COMPARATOR);
            dataListBuilder.addAll((Iterable)value);
            DataProcessorDelegate delegate = new DataProcessorDelegate(dataListBuilder.build());
            this.dataProcessorDelegates.put((Class<DataManipulator<?, ?>>)key, delegate);
        });
        SpongeDataManager manager = SpongeDataManager.getInstance();
        this.dataProcessorDelegates.forEach((key, value) -> {
            if (!Modifier.isInterface(key.getModifiers()) && !Modifier.isAbstract(key.getModifiers())) {
                DataFunction<DataContainer, DataManipulator, Optional> function = value::fill;
                SpongeDataManipulatorBuilder builder = new SpongeDataManipulatorBuilder(value, (Class<DataManipulator>)key, (DataFunction<DataContainer, DataManipulator, Optional<DataManipulator>>)function);
                manager.builderMap.put((Class<DataManipulator<?, ?>>)key, Preconditions.checkNotNull(builder));
                manager.registerBuilder(key, builder);
            } else {
                Class<? extends DataManipulator<?, ?>> clazz = this.interfaceToImplDataManipulatorClasses.get(key);
                DataFunction<DataContainer, DataManipulator, Optional> function = value::fill;
                SpongeDataManipulatorBuilder builder = new SpongeDataManipulatorBuilder(value, (Class<DataManipulator>)clazz, (DataFunction<DataContainer, DataManipulator, Optional<DataManipulator>>)function);
                manager.builderMap.put((Class<DataManipulator<?, ?>>)key, Preconditions.checkNotNull(builder));
                manager.registerBuilder(key, builder);
            }
        });
        this.tempRegistry.immutableProcessorMap.forEach((key, value) -> {
            ImmutableList.Builder dataListBuilder = ImmutableList.builder();
            value.sort(Constants.Functional.DATA_PROCESSOR_COMPARATOR);
            dataListBuilder.addAll((Iterable)value);
            DataProcessorDelegate delegate = new DataProcessorDelegate(dataListBuilder.build());
            this.immutableDataProcessorDelegates.put((Class<ImmutableDataManipulator<?, ?>>)key, delegate);
        });
        ImmutableTable.Builder builder = ImmutableTable.builder();
        this.tempRegistry.nbtProcessorMap.forEach((key, value) -> {
            HashMultimap processorMultimap = HashMultimap.create();
            for (NbtDataProcessor nbtDataProcessor : value) {
                processorMultimap.put(nbtDataProcessor.getTargetType(), nbtDataProcessor);
            }
            for (Map.Entry entry : processorMultimap.asMap().entrySet()) {
                ImmutableList.Builder processorBuilder = ImmutableList.builder();
                processorBuilder.addAll((Iterable)entry.getValue());
                NbtDataType dataType = (NbtDataType)entry.getKey();
                builder.put(key, dataType, new SpongeNbtProcessorDelegate(processorBuilder.build(), dataType));
            }
        });
        this.nbtProcessorTable = builder.build();
        ImmutableSet.Builder registrationBuilder = ImmutableSet.builder();
        ImmutableMap.Builder manipulatorBuilder = ImmutableMap.builder();
        ImmutableMap.Builder immutableBuilder = ImmutableMap.builder();
        ImmutableMap.Builder idBuilder = ImmutableMap.builder();
        ImmutableMultimap.Builder pluginBuilder = ImmutableMultimap.builder();
        this.tempRegistry.registrations.forEach(registration -> {
            registrationBuilder.add(registration);
            manipulatorBuilder.put(registration.getManipulatorClass(), registration);
            if (!registration.getImplementationClass().equals(registration.getManipulatorClass())) {
                manipulatorBuilder.put(registration.getImplementationClass(), registration);
            }
            immutableBuilder.put(registration.getImmutableManipulatorClass(), registration);
            if (!registration.getImmutableImplementationClass().equals(registration.getImmutableManipulatorClass())) {
                immutableBuilder.put(registration.getImmutableImplementationClass(), registration);
            }
            idBuilder.put(registration.getId(), registration);
            pluginBuilder.put(registration.getPluginContainer(), registration);
        });
        this.registrations = registrationBuilder.build();
        this.manipulatorRegistrationMap = manipulatorBuilder.build();
        this.immutableRegistrationMap = immutableBuilder.build();
        this.registrationMap = idBuilder.build();
        this.pluginBasedRegistrations = pluginBuilder.build();
        SpongeConfig<CustomDataConfig> customDataConfigAdapter = SpongeImpl.getCustomDataConfigAdapter();
        CustomDataRegistrationCategory customDataRegCat = customDataConfigAdapter.getConfig().getDataRegistrationConfig();
        customDataRegCat.populateRegistrations(this.registrations);
        customDataConfigAdapter.save();
        this.tempRegistry = null;
    }

    private static final class TemporaryRegistry {
        private final Map<Class<? extends DataManipulator<?, ?>>, List<DataProcessor<?, ?>>> processorMap = new MapMaker().concurrencyLevel(4).makeMap();
        private final Map<Class<? extends ImmutableDataManipulator<?, ?>>, List<DataProcessor<?, ?>>> immutableProcessorMap = new MapMaker().concurrencyLevel(4).makeMap();
        private final Map<Class<? extends DataManipulator<?, ?>>, List<NbtDataProcessor<?, ?>>> nbtProcessorMap = new MapMaker().concurrencyLevel(4).makeMap();
        private final Map<Key<? extends BaseValue<?>>, List<ValueProcessor<?, ?>>> valueProcessorMap = new MapMaker().concurrencyLevel(4).makeMap();
        private final ConcurrentSkipListSet<SpongeDataRegistration<?, ?>> registrations = new ConcurrentSkipListSet<SpongeDataRegistration>(Comparator.comparing(DataRegistration::getId));

        private TemporaryRegistry() {
        }
    }
}

