/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableSingleData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeBoundedValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractImmutableBoundedComparableData<T extends Comparable<T>, I extends ImmutableDataManipulator<I, M>, M extends DataManipulator<M, I>>
extends AbstractImmutableSingleData<T, I, M> {
    private final Class<? extends M> mutableClass;
    protected final Comparator<T> comparator;
    protected final T lowerBound;
    protected final T upperBound;
    protected final T defaultValue;
    private final ImmutableBoundedValue<T> immutableBoundedValue;

    protected AbstractImmutableBoundedComparableData(Class<I> immutableClass, T value, Key<? extends BaseValue<T>> usedKey, Comparator<T> comparator, Class<? extends M> mutableClass, T lowerBound, T upperBound, T defaultValue) {
        super(immutableClass, value, usedKey);
        this.comparator = comparator;
        Preconditions.checkArgument(!Modifier.isAbstract(mutableClass.getModifiers()), "The immutable class cannot be abstract!");
        Preconditions.checkArgument(!Modifier.isInterface(mutableClass.getModifiers()), "The immutable class cannot be an interface!");
        this.mutableClass = mutableClass;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.defaultValue = defaultValue;
        this.immutableBoundedValue = value instanceof Integer && (Integer)upperBound - (Integer)lowerBound <= 100 ? ImmutableSpongeBoundedValue.cachedOf(this.usedKey, this.defaultValue, this.value, this.comparator, this.lowerBound, this.upperBound) : SpongeValueFactory.boundedBuilder(this.usedKey).defaultValue(this.defaultValue).actualValue(this.value).minimum(this.lowerBound).maximum(this.upperBound).comparator(this.comparator).build().asImmutable();
    }

    @Override
    protected final ImmutableBoundedValue<T> getValueGetter() {
        return this.immutableBoundedValue;
    }

    @Override
    public M asMutable() {
        return (M)((DataManipulator)ReflectionUtil.createInstance(this.mutableClass, this.value, this.lowerBound, this.upperBound, this.defaultValue));
    }
}

