/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Set;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableSetValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableSingleData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeSetValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractImmutableSingleSetData<E, I extends ImmutableDataManipulator<I, M>, M extends DataManipulator<M, I>>
extends AbstractImmutableSingleData<Set<E>, I, M> {
    private final Class<? extends M> mutableClass;
    private final ImmutableSetValue<E> setValue;

    public AbstractImmutableSingleSetData(Class<I> manipulatorClass, Set<E> value, Key<? extends BaseValue<Set<E>>> usedKey, Class<? extends M> mutableClass) {
        super(manipulatorClass, ImmutableSet.copyOf(value), usedKey);
        Preconditions.checkArgument(!Modifier.isAbstract(mutableClass.getModifiers()), "The immutable class cannot be abstract!");
        Preconditions.checkArgument(!Modifier.isInterface(mutableClass.getModifiers()), "The immutable class cannot be an interface!");
        this.mutableClass = mutableClass;
        this.setValue = new ImmutableSpongeSetValue(this.usedKey, ImmutableSet.copyOf((Collection)this.value));
    }

    @Override
    protected ImmutableSetValue<E> getValueGetter() {
        return this.setValue;
    }

    @Override
    public M asMutable() {
        return (M)((DataManipulator)ReflectionUtil.createInstance(this.mutableClass, this.value));
    }
}

