/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableIgniteableData;
import org.spongepowered.api.data.manipulator.mutable.entity.IgniteableData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeIgniteableData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class ImmutableSpongeIgniteableData
extends AbstractImmutableData<ImmutableIgniteableData, IgniteableData>
implements ImmutableIgniteableData {
    private final int fireTicks;
    private final int fireDelay;
    private final ImmutableBoundedValue<Integer> fireTicksValue;
    private final ImmutableBoundedValue<Integer> fireDelayValue;

    public ImmutableSpongeIgniteableData(int fireTicks, int fireDelay) {
        super(ImmutableIgniteableData.class);
        Preconditions.checkArgument(fireTicks > 0);
        this.fireTicks = fireTicks;
        this.fireDelay = fireDelay;
        this.fireTicksValue = SpongeValueFactory.boundedBuilder(Keys.FIRE_TICKS).actualValue(this.fireTicks).defaultValue(10).minimum(1).maximum(Integer.MAX_VALUE).build().asImmutable();
        this.fireDelayValue = SpongeValueFactory.boundedBuilder(Keys.FIRE_DAMAGE_DELAY).actualValue(this.fireDelay).defaultValue(20).minimum(0).maximum(Integer.MAX_VALUE).build().asImmutable();
        this.registerGetters();
    }

    @Override
    public ImmutableBoundedValue<Integer> fireTicks() {
        return this.fireTicksValue;
    }

    @Override
    public ImmutableBoundedValue<Integer> fireDelay() {
        return this.fireDelayValue;
    }

    @Override
    public IgniteableData asMutable() {
        return new SpongeIgniteableData(this.fireTicks, this.fireDelay);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.FIRE_TICKS.getQuery(), (Object)this.fireTicks).set(Keys.FIRE_DAMAGE_DELAY.getQuery(), (Object)this.fireDelay);
    }

    public int getFireTicks() {
        return this.fireTicks;
    }

    public int getFireDelay() {
        return this.fireDelay;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.FIRE_TICKS, this::getFireTicks);
        this.registerKeyValue(Keys.FIRE_TICKS, this::fireTicks);
        this.registerFieldGetter(Keys.FIRE_DAMAGE_DELAY, this::getFireDelay);
        this.registerKeyValue(Keys.FIRE_DAMAGE_DELAY, this::fireDelay);
    }
}

