/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.entity;

import com.google.common.base.Preconditions;
import net.minecraft.init.Blocks;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableMinecartBlockData;
import org.spongepowered.api.data.manipulator.mutable.entity.MinecartBlockData;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeMinecartBlockData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeMinecartBlockData
extends AbstractImmutableData<ImmutableMinecartBlockData, MinecartBlockData>
implements ImmutableMinecartBlockData {
    private final BlockState block;
    private final int offset;
    private final ImmutableValue<BlockState> blockValue;
    private final ImmutableValue<Integer> offsetValue;

    public ImmutableSpongeMinecartBlockData() {
        this((BlockState)Blocks.field_150350_a.func_176223_P(), 6);
    }

    public ImmutableSpongeMinecartBlockData(BlockState block, int offset) {
        super(ImmutableMinecartBlockData.class);
        this.block = Preconditions.checkNotNull(block);
        this.offset = offset;
        this.blockValue = new ImmutableSpongeValue<BlockState>(Keys.REPRESENTED_BLOCK, (BlockState)Blocks.field_150350_a.func_176223_P(), block);
        this.offsetValue = new ImmutableSpongeValue<Integer>(Keys.OFFSET, 6, offset);
        this.registerGetters();
    }

    @Override
    public ImmutableValue<BlockState> block() {
        return this.blockValue;
    }

    @Override
    public ImmutableValue<Integer> offset() {
        return this.offsetValue;
    }

    @Override
    public MinecartBlockData asMutable() {
        return new SpongeMinecartBlockData(this.block, this.offset);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.REPRESENTED_BLOCK, (Object)this.block).set(Keys.OFFSET, (Object)this.offset);
    }

    public BlockState getBlock() {
        return this.block;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    protected void registerGetters() {
        this.registerKeyValue(Keys.REPRESENTED_BLOCK, this::block);
        this.registerKeyValue(Keys.OFFSET, this::offset);
        this.registerFieldGetter(Keys.REPRESENTED_BLOCK, this::getBlock);
        this.registerFieldGetter(Keys.OFFSET, this::getOffset);
    }
}

