/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.item;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableDurabilityData;
import org.spongepowered.api.data.manipulator.mutable.item.DurabilityData;
import org.spongepowered.api.data.value.immutable.ImmutableBoundedValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.item.SpongeDurabilityData;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class ImmutableSpongeDurabilityData
extends AbstractImmutableData<ImmutableDurabilityData, DurabilityData>
implements ImmutableDurabilityData {
    private final Integer durability;
    private final Boolean unbreakable;
    private final ImmutableBoundedValue<Integer> durabilityValue;
    private final ImmutableValue<Boolean> unbreakableValue;

    public ImmutableSpongeDurabilityData(int defaultDurability, int durability, boolean unbreakable) {
        super(ImmutableDurabilityData.class);
        Preconditions.checkArgument(durability >= 0);
        this.durability = durability;
        this.unbreakable = unbreakable;
        this.durabilityValue = SpongeValueFactory.boundedBuilder(Keys.ITEM_DURABILITY).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(defaultDurability).actualValue(durability).build().asImmutable();
        this.unbreakableValue = ImmutableSpongeValue.cachedOf(Keys.UNBREAKABLE, false, unbreakable);
        this.registerGetters();
    }

    public ImmutableSpongeDurabilityData() {
        this(60, 60, false);
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.ITEM_DURABILITY, () -> this.durability);
        this.registerKeyValue(Keys.ITEM_DURABILITY, this::durability);
        this.registerFieldGetter(Keys.UNBREAKABLE, () -> this.unbreakable);
        this.registerKeyValue(Keys.UNBREAKABLE, this::unbreakable);
    }

    @Override
    public ImmutableBoundedValue<Integer> durability() {
        return this.durabilityValue;
    }

    @Override
    public ImmutableValue<Boolean> unbreakable() {
        return this.unbreakableValue;
    }

    @Override
    public DurabilityData asMutable() {
        return new SpongeDurabilityData((Integer)this.durabilityValue.getDefault(), this.durability, this.unbreakable);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.ITEM_DURABILITY, (Object)this.durability).set(Keys.UNBREAKABLE, (Object)this.unbreakable);
    }
}

