/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.immutable.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableBannerData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.BannerData;
import org.spongepowered.api.data.meta.PatternLayer;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.value.immutable.ImmutablePatternListValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.data.manipulator.immutable.common.AbstractImmutableData;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeBannerData;
import org.spongepowered.common.data.value.immutable.ImmutableSpongePatternListValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.util.Constants;

public class ImmutableSpongeBannerData
extends AbstractImmutableData<ImmutableBannerData, BannerData>
implements ImmutableBannerData {
    private final DyeColor base;
    private final List<PatternLayer> layers;
    private final ImmutableValue<DyeColor> baseValue;
    private final ImmutableSpongePatternListValue layersValue;

    public ImmutableSpongeBannerData(DyeColor base, List<PatternLayer> layers) {
        super(ImmutableBannerData.class);
        this.base = Preconditions.checkNotNull(base, "Null base!");
        this.layers = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(layers, "Null pattern list!"));
        this.baseValue = ImmutableSpongeValue.cachedOf(Keys.BANNER_BASE_COLOR, Constants.Catalog.DEFAULT_BANNER_BASE, this.base);
        this.layersValue = new ImmutableSpongePatternListValue(Keys.BANNER_PATTERNS, this.layers);
        this.registerGetters();
    }

    public DyeColor getBase() {
        return this.base;
    }

    public List<PatternLayer> getLayers() {
        return this.layers;
    }

    @Override
    protected void registerGetters() {
        this.registerFieldGetter(Keys.BANNER_BASE_COLOR, this::getBase);
        this.registerKeyValue(Keys.BANNER_BASE_COLOR, this::baseColor);
        this.registerFieldGetter(Keys.BANNER_PATTERNS, this::getLayers);
        this.registerKeyValue(Keys.BANNER_PATTERNS, this::patterns);
    }

    @Override
    public ImmutableValue<DyeColor> baseColor() {
        return this.baseValue;
    }

    @Override
    public ImmutablePatternListValue patterns() {
        return this.layersValue;
    }

    @Override
    public BannerData asMutable() {
        return new SpongeBannerData(this.base, this.layers);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.BANNER_BASE_COLOR.getQuery(), (Object)this.base.getId()).set(Keys.BANNER_PATTERNS, (Object)this.layers);
    }
}

