/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableConnectedDirectionData;
import org.spongepowered.api.data.manipulator.mutable.block.ConnectedDirectionData;
import org.spongepowered.api.data.value.mutable.SetValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeConnectedDirectionData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.mutable.SpongeSetValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SpongeConnectedDirectionData
extends AbstractData<ConnectedDirectionData, ImmutableConnectedDirectionData>
implements ConnectedDirectionData {
    private Set<Direction> connectedDirections = Sets.newHashSet();

    public SpongeConnectedDirectionData(Set<Direction> connectedDirections) {
        super(ConnectedDirectionData.class);
        this.registerGettersAndSetters();
        this.connectedDirections = Sets.newHashSet(connectedDirections);
    }

    public SpongeConnectedDirectionData() {
        this(Sets.newHashSet());
    }

    @Override
    public SetValue<Direction> connectedDirections() {
        return new SpongeSetValue<Direction>(Keys.CONNECTED_DIRECTIONS, this.connectedDirections);
    }

    @Override
    public Value<Boolean> connectedNorth() {
        return new SpongeValue<Boolean>(Keys.CONNECTED_NORTH, this.connectedDirections.contains((Object)Direction.NORTH));
    }

    @Override
    public Value<Boolean> connectedSouth() {
        return new SpongeValue<Boolean>(Keys.CONNECTED_SOUTH, this.connectedDirections.contains((Object)Direction.SOUTH));
    }

    @Override
    public Value<Boolean> connectedEast() {
        return new SpongeValue<Boolean>(Keys.CONNECTED_EAST, this.connectedDirections.contains((Object)Direction.EAST));
    }

    @Override
    public Value<Boolean> connectedWest() {
        return new SpongeValue<Boolean>(Keys.CONNECTED_WEST, this.connectedDirections.contains((Object)Direction.WEST));
    }

    @Override
    public ConnectedDirectionData copy() {
        return new SpongeConnectedDirectionData(this.connectedDirections);
    }

    @Override
    public ImmutableConnectedDirectionData asImmutable() {
        return new ImmutableSpongeConnectedDirectionData(this.connectedDirections);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.CONNECTED_DIRECTIONS.getQuery(), this.connectedDirections).set(Keys.CONNECTED_NORTH.getQuery(), (Object)this.connectedDirections.contains((Object)Direction.NORTH)).set(Keys.CONNECTED_SOUTH.getQuery(), (Object)this.connectedDirections.contains((Object)Direction.SOUTH)).set(Keys.CONNECTED_EAST.getQuery(), (Object)this.connectedDirections.contains((Object)Direction.EAST)).set(Keys.CONNECTED_WEST.getQuery(), (Object)this.connectedDirections.contains((Object)Direction.WEST));
    }

    private Set<Direction> getDirections() {
        return this.connectedDirections;
    }

    private boolean isNorth() {
        return this.connectedDirections.contains((Object)Direction.NORTH);
    }

    private boolean isSouth() {
        return this.connectedDirections.contains((Object)Direction.SOUTH);
    }

    private boolean isEast() {
        return this.connectedDirections.contains((Object)Direction.EAST);
    }

    private boolean isWest() {
        return this.connectedDirections.contains((Object)Direction.WEST);
    }

    private void setDirections(Set<Direction> directions) {
        this.connectedDirections = Sets.newHashSet(directions);
    }

    private void setNorth(Boolean north) {
        if (Preconditions.checkNotNull(north).booleanValue()) {
            this.connectedDirections.add(Direction.NORTH);
        } else {
            this.connectedDirections.remove((Object)Direction.NORTH);
        }
    }

    private void setSouth(Boolean south) {
        if (Preconditions.checkNotNull(south).booleanValue()) {
            this.connectedDirections.add(Direction.SOUTH);
        } else {
            this.connectedDirections.remove((Object)Direction.SOUTH);
        }
    }

    private void setEast(Boolean east) {
        if (Preconditions.checkNotNull(east).booleanValue()) {
            this.connectedDirections.add(Direction.EAST);
        } else {
            this.connectedDirections.remove((Object)Direction.EAST);
        }
    }

    private void setWest(Boolean west) {
        if (Preconditions.checkNotNull(west).booleanValue()) {
            this.connectedDirections.add(Direction.WEST);
        } else {
            this.connectedDirections.remove((Object)Direction.WEST);
        }
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerKeyValue(Keys.CONNECTED_DIRECTIONS, this::connectedDirections);
        this.registerKeyValue(Keys.CONNECTED_NORTH, this::connectedNorth);
        this.registerKeyValue(Keys.CONNECTED_SOUTH, this::connectedSouth);
        this.registerKeyValue(Keys.CONNECTED_EAST, this::connectedEast);
        this.registerKeyValue(Keys.CONNECTED_WEST, this::connectedWest);
        this.registerFieldGetter(Keys.CONNECTED_DIRECTIONS, this::getDirections);
        this.registerFieldGetter(Keys.CONNECTED_NORTH, this::isNorth);
        this.registerFieldGetter(Keys.CONNECTED_SOUTH, this::isSouth);
        this.registerFieldGetter(Keys.CONNECTED_EAST, this::isEast);
        this.registerFieldGetter(Keys.CONNECTED_WEST, this::isWest);
        this.registerFieldSetter(Keys.CONNECTED_DIRECTIONS, this::setDirections);
        this.registerFieldSetter(Keys.CONNECTED_NORTH, this::setNorth);
        this.registerFieldSetter(Keys.CONNECTED_SOUTH, this::setSouth);
        this.registerFieldSetter(Keys.CONNECTED_EAST, this::setEast);
        this.registerFieldSetter(Keys.CONNECTED_WEST, this::setWest);
    }
}

