/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractBooleanData<M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractSingleData<Boolean, M, I> {
    private final Class<? extends I> immutableClass;
    private final Boolean defaultValue;

    protected AbstractBooleanData(Class<M> manipulatorClass, Boolean value, Key<? extends BaseValue<Boolean>> usedKey, Class<? extends I> immutableClass, Boolean defaultValue) {
        super(manipulatorClass, value, usedKey);
        Preconditions.checkArgument(!Modifier.isAbstract(immutableClass.getModifiers()), "The immutable class cannot be abstract!");
        Preconditions.checkArgument(!Modifier.isInterface(immutableClass.getModifiers()), "The immutable class cannot be an interface!");
        this.immutableClass = Preconditions.checkNotNull(immutableClass);
        this.defaultValue = Preconditions.checkNotNull(defaultValue);
    }

    @Override
    protected Value<Boolean> getValueGetter() {
        return new SpongeValue<Boolean>(this.usedKey, this.defaultValue, (Boolean)this.getValue());
    }

    @Override
    public I asImmutable() {
        return ImmutableDataCachingUtil.getManipulator(this.immutableClass, this.getValue());
    }

    @Override
    public M copy() {
        return (M)((DataManipulator)ReflectionUtil.createInstance(this.getClass(), this.getValue()));
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey.getQuery(), this.getValue());
    }
}

