/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.common;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.List;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.immutable.ImmutableListData;
import org.spongepowered.api.data.manipulator.mutable.ListData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.common.data.value.mutable.SpongeListValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractListData<E, M extends ListData<E, M, I>, I extends ImmutableListData<E, I, M>>
extends AbstractSingleData<List<E>, M, I>
implements ListData<E, M, I> {
    private final Class<? extends I> immutableClass;

    protected AbstractListData(Class<M> manipulatorClass, List<E> value, Key<? extends BaseValue<List<E>>> usedKey, Class<? extends I> immutableClass) {
        super(manipulatorClass, Lists.newArrayList(value), usedKey);
        Preconditions.checkArgument(!Modifier.isAbstract(immutableClass.getModifiers()), "The immutable class cannot be abstract!");
        Preconditions.checkArgument(!Modifier.isInterface(immutableClass.getModifiers()), "The immutable class cannot be an interface!");
        this.immutableClass = immutableClass;
    }

    @Override
    protected ListValue<E> getValueGetter() {
        return new SpongeListValue(this.usedKey, this.getValue());
    }

    @Override
    public M copy() {
        return (M)((ListData)ReflectionUtil.createInstance(this.getClass(), this.getValue()));
    }

    @Override
    public I asImmutable() {
        return (I)((ImmutableListData)ReflectionUtil.createInstance(this.immutableClass, this.getValue()));
    }

    @Override
    protected List<E> getValue() {
        return Lists.newArrayList((Iterable)super.getValue());
    }

    @Override
    protected M setValue(List<E> value) {
        return (M)((ListData)super.setValue(Lists.newArrayList(value)));
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractListData other = (AbstractListData)obj;
        return Objects.equal(this.getValue(), other.getValue());
    }

    @Override
    public ListValue<E> getListValue() {
        return this.getValueGetter();
    }

    @Override
    public List<E> asList() {
        return this.getValue();
    }

    public String toString() {
        return this.immutableClass + "{List=" + this.getValue() + '}';
    }
}

