/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import java.lang.reflect.Modifier;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.immutable.ImmutableVariantData;
import org.spongepowered.api.data.manipulator.mutable.VariantData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.util.ReflectionUtil;

public abstract class AbstractSingleCatalogData<T extends CatalogType, M extends VariantData<T, M, I>, I extends ImmutableVariantData<T, I, M>>
extends AbstractSingleData<T, M, I>
implements VariantData<T, M, I> {
    private final Class<? extends I> immutableClass;

    protected AbstractSingleCatalogData(Class<M> manipulatorClass, T value, Key<? extends BaseValue<T>> usedKey, Class<? extends I> immutableClass) {
        super(manipulatorClass, value, usedKey);
        Preconditions.checkArgument(!Modifier.isAbstract(immutableClass.getModifiers()), "The immutable class cannot be abstract!");
        Preconditions.checkArgument(!Modifier.isInterface(immutableClass.getModifiers()), "The immutable class cannot be an interface!");
        this.immutableClass = Preconditions.checkNotNull(immutableClass);
    }

    @Override
    public M copy() {
        return (M)((VariantData)ReflectionUtil.createInstance(this.getClass(), this.getValue()));
    }

    @Override
    protected Value<?> getValueGetter() {
        return this.type();
    }

    @Override
    public I asImmutable() {
        return (I)((ImmutableVariantData)ImmutableDataCachingUtil.getManipulator(this.immutableClass, this.getValue()));
    }

    @Override
    public Value<T> type() {
        return new SpongeValue(this.usedKey, this.getValue(), this.getValue());
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(this.usedKey.getQuery(), (Object)((CatalogType)this.getValue()).getId());
    }
}

