/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableHealthData;
import org.spongepowered.api.data.manipulator.mutable.entity.HealthData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeHealthData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class SpongeHealthData
extends AbstractData<HealthData, ImmutableHealthData>
implements HealthData {
    private double health;
    private double maxHealth;

    public SpongeHealthData(double health, double maxHealth) {
        super(HealthData.class);
        this.health = health;
        Preconditions.checkArgument(maxHealth > 0.0);
        this.maxHealth = maxHealth;
        this.registerGettersAndSetters();
    }

    public SpongeHealthData() {
        this(20.0, 20.0);
    }

    @Override
    public MutableBoundedValue<Double> health() {
        return SpongeValueFactory.boundedBuilder(Keys.HEALTH).minimum(0.0).maximum(this.maxHealth).defaultValue(this.maxHealth).actualValue(this.health).build();
    }

    @Override
    public MutableBoundedValue<Double> maxHealth() {
        return SpongeValueFactory.boundedBuilder(Keys.MAX_HEALTH).defaultValue(20.0).minimum(0.0).maximum(3.4028234663852886E38).actualValue(this.maxHealth).build();
    }

    @Override
    public HealthData copy() {
        return new SpongeHealthData(this.health, this.maxHealth);
    }

    @Override
    public ImmutableHealthData asImmutable() {
        return new ImmutableSpongeHealthData(this.health, this.maxHealth);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.HEALTH, (Object)this.health).set(Keys.MAX_HEALTH, (Object)this.maxHealth);
    }

    public double getHealth() {
        return this.health;
    }

    public SpongeHealthData setHealth(double value) {
        this.health = value;
        return this;
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public SpongeHealthData setMaxHealth(double value) {
        this.maxHealth = value;
        return this;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.HEALTH, this::getHealth);
        this.registerFieldSetter(Keys.HEALTH, this::setHealth);
        this.registerKeyValue(Keys.HEALTH, this::health);
        this.registerFieldGetter(Keys.MAX_HEALTH, this::getMaxHealth);
        this.registerFieldSetter(Keys.MAX_HEALTH, this::setMaxHealth);
        this.registerKeyValue(Keys.MAX_HEALTH, this::maxHealth);
    }
}

