/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableVehicleData;
import org.spongepowered.api.data.manipulator.mutable.entity.VehicleData;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeVehicleData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.util.ImplementationRequiredForTest;
import org.spongepowered.common.data.value.mutable.SpongeValue;

@ImplementationRequiredForTest
public class SpongeVehicleData
extends AbstractData<VehicleData, ImmutableVehicleData>
implements VehicleData {
    @Nullable
    private EntitySnapshot vehicle;
    @Nullable
    private EntitySnapshot baseVehicle;

    public SpongeVehicleData() {
        this((EntitySnapshot)null, null);
    }

    public SpongeVehicleData(@Nullable EntitySnapshot vehicle, @Nullable EntitySnapshot baseVehicle) {
        super(VehicleData.class);
        this.vehicle = vehicle;
        this.baseVehicle = baseVehicle;
        this.registerGettersAndSetters();
    }

    public SpongeVehicleData(Entity vehicle, Entity baseVehicle) {
        this(Preconditions.checkNotNull(vehicle, "Vehicle").createSnapshot(), Preconditions.checkNotNull(baseVehicle, "Base vehicle").createSnapshot());
    }

    @Override
    public Value<EntitySnapshot> vehicle() {
        Preconditions.checkState(this.vehicle != null, "Vehicle cannot be null!");
        Preconditions.checkState(this.baseVehicle != null, "Base Vehicle cannot be null!");
        return new SpongeValue<EntitySnapshot>(Keys.VEHICLE, this.vehicle);
    }

    @Override
    public Value<EntitySnapshot> baseVehicle() {
        Preconditions.checkState(this.vehicle != null, "Vehicle cannot be null!");
        Preconditions.checkState(this.baseVehicle != null, "Base Vehicle cannot be null!");
        return new SpongeValue<EntitySnapshot>(Keys.BASE_VEHICLE, this.baseVehicle);
    }

    @Override
    public VehicleData copy() {
        Preconditions.checkState(this.vehicle != null, "Vehicle cannot be null!");
        Preconditions.checkState(this.baseVehicle != null, "Base Vehicle cannot be null!");
        return new SpongeVehicleData(this.vehicle, this.baseVehicle);
    }

    @Override
    public ImmutableVehicleData asImmutable() {
        Preconditions.checkState(this.vehicle != null, "Vehicle cannot be null!");
        Preconditions.checkState(this.baseVehicle != null, "Base Vehicle cannot be null!");
        return new ImmutableSpongeVehicleData(this.vehicle, this.baseVehicle);
    }

    @Override
    public DataContainer toContainer() {
        Preconditions.checkState(this.vehicle != null, "Vehicle cannot be null!");
        Preconditions.checkState(this.baseVehicle != null, "Base Vehicle cannot be null!");
        return super.toContainer().set(Keys.VEHICLE, (Object)this.vehicle).set(Keys.BASE_VEHICLE, (Object)this.baseVehicle);
    }

    public EntitySnapshot getVehicle() {
        return Preconditions.checkNotNull(this.vehicle);
    }

    public SpongeVehicleData setVehicle(EntitySnapshot value) {
        this.vehicle = Preconditions.checkNotNull(value, "Vehicle cannot be null!");
        return this;
    }

    public EntitySnapshot getBaseVehicle() {
        Preconditions.checkState(this.baseVehicle != null, "Base Vehicle cannot be null!");
        return this.baseVehicle;
    }

    public SpongeVehicleData setBaseVehicle(EntitySnapshot value) {
        this.baseVehicle = Preconditions.checkNotNull(value, "Vehicle cannot be null!");
        return this;
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.VEHICLE, this::getVehicle);
        this.registerFieldSetter(Keys.VEHICLE, this::setVehicle);
        this.registerKeyValue(Keys.VEHICLE, this::vehicle);
        this.registerFieldGetter(Keys.BASE_VEHICLE, this::getBaseVehicle);
        this.registerFieldSetter(Keys.BASE_VEHICLE, this::setBaseVehicle);
        this.registerKeyValue(Keys.BASE_VEHICLE, this::baseVehicle);
    }
}

