/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.item;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.item.ImmutableDurabilityData;
import org.spongepowered.api.data.manipulator.mutable.item.DurabilityData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.item.ImmutableSpongeDurabilityData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class SpongeDurabilityData
extends AbstractData<DurabilityData, ImmutableDurabilityData>
implements DurabilityData {
    private int durability;
    private final int defaultDurability;
    private boolean unbreakable;

    public SpongeDurabilityData() {
        this(60, 60, false);
    }

    public SpongeDurabilityData(int defaultDurability, int durability, boolean unbreakable) {
        super(DurabilityData.class);
        Preconditions.checkArgument(durability >= 0);
        this.durability = durability;
        this.defaultDurability = defaultDurability;
        this.unbreakable = unbreakable;
        this.registerGettersAndSetters();
    }

    @Override
    protected void registerGettersAndSetters() {
        this.registerFieldGetter(Keys.ITEM_DURABILITY, () -> this.durability);
        this.registerFieldSetter(Keys.ITEM_DURABILITY, this::setDurability);
        this.registerKeyValue(Keys.ITEM_DURABILITY, this::durability);
        this.registerFieldGetter(Keys.UNBREAKABLE, () -> this.unbreakable);
        this.registerFieldSetter(Keys.UNBREAKABLE, value -> {
            this.unbreakable = value;
        });
        this.registerKeyValue(Keys.UNBREAKABLE, this::unbreakable);
    }

    public void setDurability(int durability) {
        Preconditions.checkArgument(durability >= 0, "Durability cannot be less than zero!");
        this.durability = durability;
    }

    @Override
    public MutableBoundedValue<Integer> durability() {
        return SpongeValueFactory.boundedBuilder(Keys.ITEM_DURABILITY).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(this.defaultDurability).actualValue(this.durability).build();
    }

    @Override
    public Value<Boolean> unbreakable() {
        return SpongeValueFactory.getInstance().createValue(Keys.UNBREAKABLE, this.unbreakable, false);
    }

    @Override
    public DurabilityData copy() {
        return new SpongeDurabilityData(this.defaultDurability, this.durability, this.unbreakable);
    }

    @Override
    public ImmutableDurabilityData asImmutable() {
        return new ImmutableSpongeDurabilityData(this.defaultDurability, this.durability, this.unbreakable);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer().set(Keys.ITEM_DURABILITY, (Object)this.durability).set(Keys.UNBREAKABLE, (Object)this.unbreakable);
    }
}

