/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.common.data.processor.common.AbstractSpongeDataProcessor;

public abstract class AbstractSingleDataProcessor<T, V extends BaseValue<T>, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractSpongeDataProcessor<M, I> {
    protected final Key<V> key;

    protected AbstractSingleDataProcessor(Key<V> key) {
        this.key = Preconditions.checkNotNull(key);
    }

    protected abstract M createManipulator();

    @Override
    public Optional<M> createFrom(DataHolder dataHolder) {
        if (!this.supports(dataHolder)) {
            return Optional.empty();
        }
        Optional optional = this.from(dataHolder);
        if (!optional.isPresent()) {
            return Optional.of(this.createManipulator());
        }
        return optional;
    }

    @Override
    public Optional<M> fill(DataHolder dataHolder, M manipulator, MergeFunction overlap) {
        if (!this.supports(dataHolder)) {
            return Optional.empty();
        }
        DataManipulator merged = (DataManipulator)Preconditions.checkNotNull(overlap).merge(manipulator.copy(), this.from(dataHolder).orElse(null));
        return Optional.of(manipulator.set(this.key, merged.get(this.key).get()));
    }
}

