/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.ValueProcessor;

public abstract class AbstractSpongeValueProcessor<C, E, V extends BaseValue<E>>
implements ValueProcessor<E, V> {
    private final Class<C> containerClass;
    protected final Key<V> key;

    protected AbstractSpongeValueProcessor(Class<C> containerClass, Key<V> key) {
        this.key = Preconditions.checkNotNull(key, "The key is null!");
        this.containerClass = containerClass;
    }

    protected abstract V constructValue(E var1);

    protected abstract boolean set(C var1, E var2);

    protected abstract Optional<E> getVal(C var1);

    protected abstract ImmutableValue<E> constructImmutableValue(E var1);

    protected boolean supports(C container) {
        return true;
    }

    @Override
    public boolean supports(ValueContainer<?> container) {
        return this.containerClass.isInstance(container) && this.supports((C)container);
    }

    @Override
    public final Key<? extends BaseValue<E>> getKey() {
        return this.key;
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Optional<E> getValueFromContainer(ValueContainer<?> container) {
        if (!this.supports(container)) {
            return Optional.empty();
        }
        return this.getVal(container);
    }

    @Override
    public Optional<V> getApiValueFromContainer(ValueContainer<?> container) {
        Optional<E> optionalValue = this.getValueFromContainer(container);
        if (optionalValue.isPresent()) {
            return Optional.of(this.constructValue(optionalValue.get()));
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult offerToStore(ValueContainer<?> container, E value) {
        ImmutableValue<E> newValue = this.constructImmutableValue(value);
        if (this.supports(container)) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            Optional<E> oldVal = this.getVal(container);
            try {
                if (this.set(container, value)) {
                    if (oldVal.isPresent()) {
                        builder.replace(this.constructImmutableValue(oldVal.get()));
                    }
                    return builder.result(DataTransactionResult.Type.SUCCESS).success(newValue).build();
                }
                return builder.result(DataTransactionResult.Type.FAILURE).reject(newValue).build();
            }
            catch (Exception e) {
                SpongeImpl.getLogger().debug("An exception occurred when setting data: ", (Throwable)e);
                return builder.result(DataTransactionResult.Type.ERROR).reject(newValue).build();
            }
        }
        return DataTransactionResult.failResult(newValue);
    }
}

