/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.api.item.FireworkEffect;
import org.spongepowered.api.item.FireworkShape;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.item.SpongeFireworkEffectBuilder;
import org.spongepowered.common.item.SpongeFireworkShape;
import org.spongepowered.common.item.inventory.SpongeItemStackBuilder;
import org.spongepowered.common.mixin.core.entity.item.EntityFireworkRocketAccessor;

public class FireworkUtils {
    public static final BiMap<Byte, SpongeFireworkShape> shapeMapping = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put((Object)0, new SpongeFireworkShape("minecraft:ball", "Ball"))).put((Object)1, new SpongeFireworkShape("minecraft:large_ball", "Large Ball"))).put((Object)2, new SpongeFireworkShape("minecraft:star", "Star"))).put((Object)3, new SpongeFireworkShape("minecraft:creeper", "Creeper"))).put((Object)4, new SpongeFireworkShape("minecraft:burst", "Burst"))).build();

    public static ItemStack getItem(EntityFireworkRocket firework) {
        ItemStack item = (ItemStack)firework.func_184212_Q().func_187225_a(EntityFireworkRocketAccessor.accessor$getFireworkItemParameter());
        if (item.func_190926_b()) {
            item = (ItemStack)new SpongeItemStackBuilder().itemType(ItemTypes.FIREWORKS).build();
            firework.func_184212_Q().func_187227_b(EntityFireworkRocketAccessor.accessor$getFireworkItemParameter(), (Object)item);
        }
        return item;
    }

    @Nullable
    public static FireworkEffect getChargeEffect(ItemStack item) {
        Preconditions.checkArgument(item.func_77973_b() == Items.field_151154_bQ, "Item is not a firework!");
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            return null;
        }
        NBTTagCompound firework = tag.func_74775_l("Explosion");
        if (firework.func_82582_d()) {
            return null;
        }
        return FireworkUtils.fromNbt(firework);
    }

    public static FireworkShape getShape(byte id) {
        if (id > 4) {
            id = 0;
        }
        return (FireworkShape)shapeMapping.get(id);
    }

    public static byte getShapeId(FireworkShape shape) {
        return (Byte)shapeMapping.inverse().get(shape);
    }

    public static FireworkEffect fromNbt(NBTTagCompound effectNbt) {
        SpongeFireworkEffectBuilder builder = new SpongeFireworkEffectBuilder();
        if (effectNbt.func_74764_b("Flicker")) {
            builder.flicker(effectNbt.func_74767_n("Flicker"));
        }
        if (effectNbt.func_74764_b("Trail")) {
            builder.trail(effectNbt.func_74767_n("Trail"));
        }
        if (effectNbt.func_74764_b("Type")) {
            byte type = effectNbt.func_74771_c("Type");
            builder.shape(FireworkUtils.getShape(type));
        }
        if (effectNbt.func_74764_b("Colors")) {
            int[] colorsRaw;
            ArrayList<Color> colors = Lists.newArrayList();
            for (int color : colorsRaw = effectNbt.func_74759_k("Colors")) {
                colors.add(Color.ofRgb(color));
            }
            builder.colors(colors);
        }
        if (effectNbt.func_74764_b("FadeColors")) {
            int[] fadesRaw;
            ArrayList<Color> fades = Lists.newArrayList();
            for (int fade : fadesRaw = effectNbt.func_74759_k("FadeColors")) {
                fades.add(Color.ofRgb(fade));
            }
            builder.fades(fades);
        }
        return builder.build();
    }

    public static NBTTagCompound toNbt(FireworkEffect effect) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("Flicker", effect.flickers());
        tag.func_74757_a("Trail", effect.hasTrail());
        tag.func_74774_a("Type", FireworkUtils.getShapeId(effect.getShape()));
        int[] colorsArray = new int[effect.getColors().size()];
        List<Color> colors = effect.getColors();
        for (int i = 0; i < colors.size(); ++i) {
            colorsArray[i] = colors.get(i).getRgb();
        }
        tag.func_74783_a("Colors", colorsArray);
        int[] fadeArray = new int[effect.getFadeColors().size()];
        List<Color> fades = effect.getFadeColors();
        for (int i = 0; i < fades.size(); ++i) {
            fadeArray[i] = fades.get(i).getRgb();
        }
        tag.func_74783_a("FadeColors", fadeArray);
        return tag;
    }

    public static boolean setFireworkEffects(Object object, List<? extends FireworkEffect> effects) {
        ItemStack item = ItemStack.field_190927_a;
        if (object instanceof ItemStack) {
            item = (ItemStack)object;
        }
        if (object instanceof EntityFireworkRocket) {
            item = FireworkUtils.getItem((EntityFireworkRocket)object);
        }
        if (item.func_190926_b()) {
            return false;
        }
        if (item.func_77973_b() == Items.field_151154_bQ) {
            NBTTagCompound tag = item.func_77978_p();
            if (tag == null) {
                return true;
            }
            if (!effects.isEmpty()) {
                tag.func_74782_a("Explosion", (NBTBase)FireworkUtils.toNbt(effects.get(0)));
            } else {
                tag.func_82580_o("Explosion");
            }
            return true;
        }
        if (item.func_77973_b() == Items.field_151152_bP) {
            NBTTagList nbtEffects = new NBTTagList();
            effects.stream().map(FireworkUtils::toNbt).forEach(arg_0 -> ((NBTTagList)nbtEffects).func_74742_a(arg_0));
            NBTTagCompound fireworks = item.func_190925_c("Fireworks");
            fireworks.func_74782_a("Explosions", (NBTBase)nbtEffects);
            return true;
        }
        return false;
    }

    public static Optional<List<FireworkEffect>> getFireworkEffects(Object object) {
        AbstractCollection effects;
        ItemStack item = ItemStack.field_190927_a;
        if (object instanceof ItemStack) {
            item = (ItemStack)object;
        }
        if (object instanceof EntityFireworkRocket) {
            item = FireworkUtils.getItem((EntityFireworkRocket)object);
        }
        if (item.func_190926_b()) {
            return Optional.empty();
        }
        if (item.func_77973_b() == Items.field_151152_bP) {
            NBTTagCompound fireworks = item.func_179543_a("Fireworks");
            if (fireworks == null || !fireworks.func_74764_b("Explosions")) {
                return Optional.empty();
            }
            NBTTagList effectsNbt = fireworks.func_150295_c("Explosions", 10);
            effects = Lists.newArrayList();
            for (int i = 0; i < effectsNbt.func_74745_c(); ++i) {
                NBTTagCompound effectNbt = effectsNbt.func_150305_b(i);
                effects.add((FireworkEffect)FireworkUtils.fromNbt(effectNbt));
            }
        } else {
            FireworkEffect effect = FireworkUtils.getChargeEffect(item);
            if (effect == null) {
                return Optional.empty();
            }
            effects = ImmutableList.of(effect);
        }
        return Optional.of(effects);
    }

    public static boolean removeFireworkEffects(Object object) {
        ItemStack item = ItemStack.field_190927_a;
        if (object instanceof ItemStack) {
            item = (ItemStack)object;
        }
        if (object instanceof EntityFireworkRocket) {
            item = FireworkUtils.getItem((EntityFireworkRocket)object);
        }
        if (item.func_190926_b()) {
            return false;
        }
        if (item.func_77973_b() == Items.field_151154_bQ) {
            NBTTagCompound tag = item.func_77978_p();
            if (tag == null) {
                return true;
            }
            tag.func_82580_o("Explosion");
            return true;
        }
        if (item.func_77973_b() == Items.field_151152_bP) {
            NBTTagCompound fireworks = item.func_190925_c("Fireworks");
            fireworks.func_82580_o("Explosions");
            return true;
        }
        return false;
    }
}

