/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntitySkull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.type.SkullType;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.SpongeRepresentedPlayerData;
import org.spongepowered.common.data.type.SpongeSkullType;
import org.spongepowered.common.util.Constants;

public class SkullUtils {
    public static boolean supportsObject(Object object) {
        return object instanceof TileEntitySkull || SkullUtils.isValidItemStack(object);
    }

    public static SkullType getSkullType(int skullType) {
        for (SkullType type : SpongeImpl.getRegistry().getAllOf(SkullType.class)) {
            if (!(type instanceof SpongeSkullType) || ((SpongeSkullType)type).getByteId() != skullType) continue;
            return type;
        }
        return Constants.TileEntity.Skull.DEFAULT_TYPE;
    }

    public static boolean isValidItemStack(Object container) {
        return container instanceof ItemStack && ((ItemStack)container).func_77973_b().equals(Items.field_151144_bL);
    }

    public static boolean setProfile(TileEntitySkull tileEntitySkull, @Nullable GameProfile profile) {
        if (SkullUtils.getSkullType(tileEntitySkull.func_145904_a()).equals(SkullTypes.PLAYER)) {
            GameProfile newProfile = SpongeRepresentedPlayerData.NULL_PROFILE.equals(profile) ? null : SkullUtils.resolveProfileIfNecessary(profile);
            tileEntitySkull.func_152106_a((com.mojang.authlib.GameProfile)((Object)newProfile));
            tileEntitySkull.func_70296_d();
            tileEntitySkull.func_145831_w().func_184138_a(tileEntitySkull.func_174877_v(), tileEntitySkull.func_145831_w().func_180495_p(tileEntitySkull.func_174877_v()), tileEntitySkull.func_145831_w().func_180495_p(tileEntitySkull.func_174877_v()), 3);
            return true;
        }
        return false;
    }

    public static boolean setProfile(ItemStack skull, @Nullable GameProfile profile) {
        if (SkullUtils.isValidItemStack(skull) && SkullUtils.getSkullType(skull.func_77960_j()).equals(SkullTypes.PLAYER)) {
            if (profile == null || profile.equals(SpongeRepresentedPlayerData.NULL_PROFILE)) {
                if (skull.func_77978_p() != null) {
                    skull.func_77978_p().func_82580_o("SkullOwner");
                }
            } else {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTUtil.func_180708_a((NBTTagCompound)nbt, (com.mojang.authlib.GameProfile)((com.mojang.authlib.GameProfile)((Object)SkullUtils.resolveProfileIfNecessary(profile))));
                skull.func_77983_a("SkullOwner", (NBTBase)nbt);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static GameProfile resolveProfileIfNecessary(@Nullable GameProfile profile) {
        if (profile == null) {
            return null;
        }
        if (profile.getPropertyMap().containsKey("textures")) {
            return profile;
        }
        CompletableFuture<GameProfile> future = Sponge.getGame().getServer().getGameProfileManager().fill(profile);
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            SpongeImpl.getLogger().debug("Exception while trying to fill skull GameProfile for '" + profile + "'", (Throwable)e);
            return profile;
        }
    }
}

