/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.IWorldNameable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableDisplayNameData;
import org.spongepowered.api.data.manipulator.mutable.DisplayNameData;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.data.manipulator.immutable.ImmutableSpongeDisplayNameData;
import org.spongepowered.common.data.manipulator.mutable.SpongeDisplayNameData;
import org.spongepowered.common.data.processor.common.AbstractSingleDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.text.SpongeTexts;

public class DisplayNameDataProcessor
extends AbstractSingleDataProcessor<Text, Value<Text>, DisplayNameData, ImmutableDisplayNameData> {
    public DisplayNameDataProcessor() {
        super(Keys.DISPLAY_NAME);
    }

    @Override
    protected DisplayNameData createManipulator() {
        return new SpongeDisplayNameData();
    }

    @Override
    public boolean supports(DataHolder holder) {
        return holder instanceof Entity || holder instanceof ItemStack || holder instanceof IWorldNameable;
    }

    @Override
    public Optional<DisplayNameData> from(DataHolder holder) {
        if (holder instanceof Entity) {
            Text displayName = ((EntityBridge)((Object)holder)).bridge$getDisplayNameText();
            if (displayName != null) {
                return Optional.of(new SpongeDisplayNameData(displayName));
            }
            return Optional.empty();
        }
        if (holder instanceof ItemStack) {
            ItemStack stack = (ItemStack)holder;
            if (!stack.func_82837_s()) {
                return Optional.empty();
            }
            if (stack.func_77973_b() == Items.field_151164_bB) {
                NBTTagCompound compound = stack.func_77978_p();
                if (compound == null) {
                    return Optional.empty();
                }
                return Optional.of(new SpongeDisplayNameData(SpongeTexts.fromLegacy(compound.func_74779_i("title"))));
            }
            NBTTagCompound compound = ((ItemStack)holder).func_179543_a("display");
            if (compound != null && compound.func_150297_b("Name", 8)) {
                return Optional.of(new SpongeDisplayNameData(SpongeTexts.fromLegacy(compound.func_74779_i("Name"))));
            }
            return Optional.empty();
        }
        if (holder instanceof IWorldNameable) {
            if (((IWorldNameable)holder).func_145818_k_()) {
                String customName = ((IWorldNameable)holder).func_70005_c_();
                SpongeDisplayNameData data = new SpongeDisplayNameData(SpongeTexts.fromLegacy(customName));
                return Optional.of(data);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public Optional<DisplayNameData> fill(DataContainer container, DisplayNameData displayNameData) {
        String json = DataUtil.getData((DataView)container, Keys.DISPLAY_NAME, String.class);
        return Optional.of(displayNameData.set(Keys.DISPLAY_NAME, TextSerializers.JSON.deserialize(json)));
    }

    @Override
    public DataTransactionResult set(DataHolder holder, DisplayNameData manipulator, MergeFunction function) {
        if (holder instanceof EntityBridge ? holder instanceof Player : !(holder instanceof ItemStack)) {
            return DataTransactionResult.failResult(manipulator.getValues());
        }
        Optional<DisplayNameData> old = this.from(holder);
        DisplayNameData merged = Preconditions.checkNotNull(function).merge(old.orElse(null), manipulator);
        Text newValue = (Text)merged.displayName().get();
        ImmutableValue<Text> immutableValue = merged.displayName().asImmutable();
        try {
            if (holder instanceof EntityBridge) {
                ((EntityBridge)((Object)holder)).bridge$setDisplayName(newValue);
            } else {
                ItemStack stack = (ItemStack)holder;
                if (stack.func_77973_b() == Items.field_151164_bB) {
                    stack.func_77983_a("title", (NBTBase)new NBTTagString(SpongeTexts.toLegacy(newValue)));
                } else {
                    stack.func_151001_c(SpongeTexts.toLegacy(newValue));
                }
            }
        }
        catch (Exception e) {
            SpongeImpl.getLogger().debug("An exception occurred when setting data: ", (Throwable)e);
            return DataTransactionResult.errorResult(immutableValue);
        }
        return old.map(displayNameData -> DataTransactionResult.successReplaceResult(displayNameData.displayName().asImmutable(), immutableValue)).orElseGet(() -> DataTransactionResult.successResult(immutableValue));
    }

    @Override
    public Optional<ImmutableDisplayNameData> with(Key<? extends BaseValue<?>> key, Object value, ImmutableDisplayNameData immutable) {
        if (key == this.key) {
            return Optional.of(new ImmutableSpongeDisplayNameData((Text)value));
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult remove(DataHolder holder) {
        if (holder instanceof Entity) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            Optional<DisplayNameData> optional = this.from(holder);
            if (optional.isPresent()) {
                try {
                    ((EntityBridge)((Object)holder)).bridge$setDisplayName(null);
                    return builder.replace(optional.get().getValues()).result(DataTransactionResult.Type.SUCCESS).build();
                }
                catch (Exception e) {
                    SpongeImpl.getLogger().error("There was an issue resetting the display name from an Entity!", (Throwable)e);
                    return builder.result(DataTransactionResult.Type.ERROR).build();
                }
            }
            return builder.result(DataTransactionResult.Type.SUCCESS).build();
        }
        if (holder instanceof ItemStack) {
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            Optional<DisplayNameData> optional = this.from(holder);
            if (optional.isPresent()) {
                try {
                    ((ItemStack)holder).func_135074_t();
                    return builder.replace(optional.get().getValues()).result(DataTransactionResult.Type.SUCCESS).build();
                }
                catch (Exception e) {
                    SpongeImpl.getLogger().error("There was an issue removing the display name from an ItemStack!", (Throwable)e);
                    return builder.result(DataTransactionResult.Type.ERROR).build();
                }
            }
            return builder.result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public boolean supports(EntityType type) {
        return Entity.class.isAssignableFrom(type.getEntityClass());
    }
}

