/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.entity.monster.EntityEndermite;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableExpirableData;
import org.spongepowered.api.data.manipulator.mutable.entity.ExpirableData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeExpirableData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.mixin.core.entity.monster.EntityEndermiteAccessor;

public class EndermiteExpirableDataProcessor
extends AbstractEntitySingleDataProcessor<EntityEndermite, Integer, MutableBoundedValue<Integer>, ExpirableData, ImmutableExpirableData> {
    public EndermiteExpirableDataProcessor() {
        super(EntityEndermite.class, Keys.EXPIRATION_TICKS);
    }

    @Override
    protected ExpirableData createManipulator() {
        return new SpongeExpirableData(0, 2400);
    }

    @Override
    protected boolean set(EntityEndermite entity, Integer value) {
        if (entity.func_104002_bU()) {
            return false;
        }
        Preconditions.checkArgument(value >= 0);
        Preconditions.checkArgument(value <= 2400);
        ((EntityEndermiteAccessor)entity).accessor$setLifetime(value);
        return true;
    }

    @Override
    protected Optional<Integer> getVal(EntityEndermite entity) {
        return entity.func_104002_bU() ? Optional.empty() : Optional.of(((EntityEndermiteAccessor)entity).accessor$getLifetime());
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer actualValue) {
        return SpongeValueFactory.boundedBuilder(Keys.EXPIRATION_TICKS).minimum(0).maximum(2400).defaultValue(0).actualValue(actualValue).build();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

